package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;

public class FetchDischargeNoteRequestHandler extends AbstractFetchPatientDataRequestHandler<DischargeNoteDataLayer, ProviderNote> {

	@Override
	protected ProviderNote invokeDataLayerToFetchSingleItem(DischargeNoteDataLayer datalayer, PatientIdentifier patientIdentifier, String dataId, RequestMessage requestMessage) {
		DateFilter dateFilter = requestMessage.getValue("date-filter");
		return datalayer.fetchDischargeNote(patientIdentifier, dateFilter);
	}
}
