package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.AbstractFetchPatientDataListRequestHandler;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestReader;
import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;

public class FetchAdmissionListRequestHandler extends AbstractFetchPatientDataListRequestHandler<AdmissionDataLayer, Admissions, Admission> {

	@Override
	protected Admissions invokeDataLayerToFetchList(AdmissionDataLayer datalayer, RequestMessage requestMessage, PatientDataFetchRequestReader messageReader) {
		Admissions admissions = datalayer.fetchAdmissions(messageReader.getPatientIdentifier(), messageReader.getDateFilter());
		admissions.sortDescending("admissionDate");
		
		return admissions;
	}

}
