package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.ResponseMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataResponseReader;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class AdmissionDataService {
	private Router router = new Router();

	public Admissions getPatientAdmissions(PatientIdentifier patientIdentifier, DateFilter dateFilter, ScopeFilter scopeFilter) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.admission).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).forDateFilter(dateFilter).excludeDetails().build();
		ResponseMessage responseMessage = router.execute(request);
		return PatientDataResponseReader.<Admissions, Admission> fromResponse(responseMessage).getDataListNoNull(Admissions.class);
	}

	public Admissions getPatientAdmissionsWithDetails(PatientIdentifier patientIdentifier, DateFilter dateFilter, ScopeFilter scopeFilter) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveList().forDomain(Domain.admission).forPatientIdentifier(patientIdentifier).forScopeFilter(scopeFilter).forDateFilter(dateFilter).includeDetails().build();
		ResponseMessage responseMessage = router.execute(request);
		return PatientDataResponseReader.<Admissions, Admission> fromResponse(responseMessage).getDataListNoNull(Admissions.class);
	}

	public Admission getPatientAdmission(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveSingleById().forDomain(Domain.admission).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).build();
		ResponseMessage responseMessage = router.execute(request);
		return PatientDataResponseReader.<Admissions, Admission> fromResponse(responseMessage).getDataItem();
	}

	public ProviderNote fetchDischargeNoteForInpatientDateRange(PatientIdentifier patientIdentifier, DataIdentifier dataIdentifier, DateFilter dateFilter) {
		RequestMessage request = PatientDataFetchRequestBuilder.forRetrieveSingleById().forDomain(Domain.dischargeNote).forPatientIdentifier(patientIdentifier).forDataIdentifier(dataIdentifier).forDateFilter(dateFilter).build();
		ResponseMessage response = router.execute(request);
		return PatientDataResponseReader.<ProviderNotes, ProviderNote> fromResponse(response).getDataItem();
	}

}
