package com.agilex.healthcare.mobilehealthplatform.utils.uriformaters;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.net.URI;
import java.util.Iterator;

import javax.annotation.Resource;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import com.agilex.healthcare.mobilehealthplatform.utils.PropertyHelper;
import com.agilex.healthcare.utility.NullChecker;

public class ResourceDirectoryBuilderTest extends SpringBasedIntegration {
	@Resource ResourceDirectoryBuilder resourceDirectoryBuilder;
	
	@Resource PropertyHelper propertyHelper;
	
	@Test
	public void shouldHaveUserSessionLink() {
		
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/user-session");
		
		testAtomLink(baseURI, expectedURI, LinkTitles.UserSession);
	}

	@Test
	public void shouldHaveMhpUserLink() {
		
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/mhpuser");
		
		testAtomLink(baseURI, expectedURI, "mhpuser");
	}
	
	@Test
	public void shouldHaveHealthCheckLink() {
		
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/health?e");
		
		testAtomLink(baseURI, expectedURI, "health-check");
	}
	
	@Test
	public void shouldHavePatientsLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/patients");
		
		testAtomLink(baseURI, expectedURI, "patients");
	}
	
	@Test
	public void shouldHaveTokenLink() {

		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/AuthorizationServices/rest/token");

		testAtomLink(baseURI, expectedURI, "token");
	}
	
	
	@Test
	public void shouldHaveMetricsLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/metrics");
		
		testAtomLink(baseURI, expectedURI, "system-metrics");
	}
	
	@Test
	public void shouldHaveAppointmentsLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/provider/appointments");
		
		testAtomLink(baseURI, expectedURI, "current-provider-appointments");
	}
	
	@Test
	public void shouldHaveOauthAuthorizeLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		
		URI expectedURI;
		if (NullChecker.isNotNullish(propertyHelper.getProperty("oauth.authorize_url"))) {
			expectedURI = URI.create(propertyHelper.getProperty("oauth.authorize_url"));
		} else {
			expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/oauth/authorize");
		}
		
		
		testAtomLink(baseURI, expectedURI, LinkTitles.OAuthAuthorize);
	}
	
	@Test
	public void shouldHaveOauthTokenLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI;
		if (NullChecker.isNotNullish(propertyHelper.getProperty("oauth.token_url"))) {
			expectedURI = URI.create(propertyHelper.getProperty("oauth.token_url"));
		} else {
			expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/oauth/token");
		}
		testAtomLink(baseURI, expectedURI, LinkTitles.OAuthToken);
	}
	
	@Test
	public void shouldHaveLoginCredentialsLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/j_spring_security_check");
		
		testAtomLink(baseURI, expectedURI, "login-credentials");
	}
	
	@Test
	public void shouldHaveLogoutLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/logout");
		
		testAtomLink(baseURI, expectedURI, "logout");
	}
	
	@Test
	public void shouldHaveFeedbackLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/feedback");
		
		testAtomLink(baseURI, expectedURI, "feedback");
	}
	
	@Test
	public void shouldHaveLearnLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/learn/conditions");
		
		testAtomLink(baseURI, expectedURI, "learn-conditions");
	}
	
	@Test
	public void shouldHaveAssessmentsLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/assessments");
		
		testAtomLink(baseURI, expectedURI, "assessments");
	}

	@Test
	public void shouldHaveHealthAssessmentAssessmentsLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/assessments/health-assessment");
		
		testAtomLink(baseURI, expectedURI, "health-assessment-assessments");
	}

	@Test
	public void shouldHaveAssessmentResultsLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/assessments/results");
		
		testAtomLink(baseURI, expectedURI, LinkTitles.AssessmentResults);
	}

	@Test
	public void shouldHaveAppointmentsMetadataLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/appointment-service/metadata");
		
		testAtomLink(baseURI, expectedURI, LinkTitles.AppointmentsMetadata);
	}

	@Test
	public void shouldHaveAppointmentRequestsLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/appointment-service/appointment-requests");
		
		testAtomLink(baseURI, expectedURI, LinkTitles.AppointmentRequests);
	}

	@Test
	public void shouldHaveAppointmentRequestFeedbackLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/feedback/appointment-request");
		
		testAtomLink(baseURI, expectedURI, LinkTitles.AppointmentRequestFeedback);
	}
	

	@Test
	public void shouldHavePublicUserSessionLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/user-session");
		
		testAtomLink(baseURI, expectedURI, LinkTitles.PublicUserSession);
	}

	@Test
	public void shouldHaveLaunchpadMetadataLink() {
	
		URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
		URI expectedURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest/public/launchpad/metadata");
		
		testAtomLink(baseURI, expectedURI, LinkTitles.LaunchpadMetadata);
	}

    @Test
    public void shouldHaveLaunchpadLink() {
        URI baseURI = URI.create("http://instance.of.mha/MobileHealthPlatformWeb/rest");
        URI expectedURI = URI.create("http://instance.of.mha/launchpad");

        testAtomLink(baseURI, expectedURI, LinkTitles.LaunchPadLink);
    }
	
	private void testAtomLink(URI baseURI, URI expectedURI, String expectedTitle) {
		ResourceDirectory resourceDirectory = resourceDirectoryBuilder.getResourceDirectory(baseURI, null);
		AtomLinks links = resourceDirectory.getLink();
		
		boolean exists = false;
		AtomLink matchedLink = null;
		
		for (Iterator<AtomLink> iterator = links.iterator(); iterator.hasNext();) {
			
			AtomLink atomLink = (AtomLink) iterator.next();
			
			if (atomLink.getTitle().equals(expectedTitle)) {
				matchedLink = atomLink;
				exists = true;
			}
		}
		
		assertTrue(exists);
		assertEquals(expectedURI, matchedLink.getHref());
	}
}
