package com.agilex.healthcare.mobilehealthplatform.utils;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import javax.annotation.Resource;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.enumeration.AppType;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import com.agilex.healthcare.utility.NullChecker;

public class PilotFacilitiesHelperTest extends SpringBasedIntegration {
	@Resource PilotFacilitiesHelper pilotFacilitiesHelper;
	
	@Test
	public void emptyAppShouldHaveNoPilotSites() {
		List<String> pilotSites = pilotFacilitiesHelper.getPilotSites();
		assertTrue(NullChecker.isNullish(pilotSites));
	}
	
	@Test
	public void invalidAppShouldHaveNoPilotSites() {
		List<String> pilotSites = pilotFacilitiesHelper.getPilotSites("FAKE APP");
		assertTrue(NullChecker.isNullish(pilotSites));
	}
	
	@Test
	public void mbbShouldHavePilotSites() {
		List<String> pilotSites = pilotFacilitiesHelper.getPilotSites(AppType.MBB.getName());
		assertNotNull(pilotSites);
		assertTrue(pilotSites.size() > 0);
		
		for (String pilotSite : pilotSites) {
			assertTrue(NullChecker.isNotNullish(pilotSite));
		}
	}
	
	@Test
	public void varcarShouldHavePilotSites() {
		List<String> pilotSites = pilotFacilitiesHelper.getPilotSites(AppType.VARCAR.getName());
		assertNotNull(pilotSites);
		assertTrue(pilotSites.size() > 0);
		
		for (String pilotSite : pilotSites) {
			assertTrue(NullChecker.isNotNullish(pilotSite));
		}
	}
}
