package com.agilex.healthcare.mobilehealthplatform.test;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * <p>
 * A base class helper to enable spring based integration tests. These settings
 * enable Junit to be Spring context Aware, so the Junit class itself can
 * consume any spring managed resource. It also makes all Junit classes to share the same Spring context (so applicationContext loads once and gets shared).
 * These features come from spring-test lib
 * </p>
 * 
 * See the spring configuration file for more details on what configs will be loaded. 
 * 
 * @author Seena
 * 
 */
@ContextConfiguration(locations = { "classpath:applicationContext.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public abstract class SpringBasedIntegration {
	
	
	@BeforeClass
	public static void init() throws Exception {
		
		SecurityContextHolder.getContext().setAuthentication(
	            new UsernamePasswordAuthenticationToken("test" , "test"));

	}

    @AfterClass
    public static void cleanup() {
        SecurityContextHolder.clearContext();
    }
}
