package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpSession;

import junit.framework.Assert;

import org.junit.Test;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;


public class StaffUserDisclaimerVoterTest extends AbstractVoterTest{

	
	@Test
	public void supportsDesiredConfigAccess(){
		Assert.assertTrue(supportsConfigAttribute("CHECK_STAFF_USER_DISCLAIMER", new StaffUserDisclaimerVoter<FilterInvocation>()));
	}

	@Test
	public void doesNotSupportsInvalidConfigAccess(){
		Assert.assertFalse(supportsConfigAttribute(Roles.ROLE_CONSUMER, new StaffUserDisclaimerVoter<FilterInvocation>()));
	}
	
	@Test
	public void nonStaffUserAbstains(){
		StaffUserDisclaimerVoter<FilterInvocation> voter = new StaffUserDisclaimerVoter<FilterInvocation>();
		List<GrantedAuthority> authorities = createPatientAuthorities();


		AppUser principal = createPrincipal("zztest.patient01", new PatientIdentifier(defaultAssigningAuthority, defaultTargetPatientId), authorities);
		Object credentials = null;

		Authentication authentication = createAuthentication(authorities, principal, credentials);

		//Use knowledge of currently hard-coded list of patients that are in pilot program
		FilterInvocation fi = createFilterInvocation("mock-aa", "D123403");
		
		Collection<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
		
		int result = voter.vote(authentication, fi, attributes);
		
		Assert.assertEquals(AccessDecisionVoter.ACCESS_ABSTAIN, result);
	}
	
	/* TODO: RENABLE TEST WHEN STAFF USER DISCLAIMER VOTER IS TURNED ON
	@Test
	public void staffUserDisclaimerNotFound(){
		StaffUserDisclaimerVoter<FilterInvocation> voter = new StaffUserDisclaimerVoter<FilterInvocation>();
		List<GrantedAuthority> authorities = createStaffAuthorities();

		AppUser principal = createPrincipal(authorities);
		Object credentials = null;

		Authentication authentication = createAuthentication(authorities, principal, credentials);

		//Use knowledge of currently hard-coded list of patients that are in pilot program
		FilterInvocation fi = createFilterInvocation("mock-aa", "D123403");
		
		Collection<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
        ConfigAttribute attribute = new ConfigAttribute() {
            @Override
            public String getAttribute() {
                return "CHECK_STAFF_USER_DISCLAIMER";
            }
        };
        attributes.add(attribute);
		
        boolean notFound = false;
        try {
			voter.vote(authentication, fi, attributes);
        } catch (WebApplicationException e) {
        	if (e.getResponse().getStatus() == Status.NO_CONTENT.getStatusCode()) {
        		 notFound = true;
        	}
        }
        assertTrue(notFound);
	}
	*/
	

	@Test
	public void staffUserDisclaimerAccepted(){
		StaffUserDisclaimerVoter<FilterInvocation> voter = new StaffUserDisclaimerVoter<FilterInvocation>();
		List<GrantedAuthority> authorities = createStaffAuthorities();

		AppUser principal = createPrincipal("zztest.patient01", new PatientIdentifier(defaultAssigningAuthority, defaultTargetPatientId), authorities);
		Object credentials = null;

		Authentication authentication = createAuthentication(authorities, principal, credentials);

		//Use knowledge of currently hard-coded list of patients that are in pilot program
		FilterInvocation fi = createFilterInvocation("mock-aa", "D123403");
		
		Collection<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
        ConfigAttribute attribute = new ConfigAttribute() {
            @Override
            public String getAttribute() {
                return "CHECK_STAFF_USER_DISCLAIMER";
            }
        };
        attributes.add(attribute);
		
        HttpSession session = VoterHelper.getHttpSession(fi);
        final String sudSessionKey = "StaffUserDisclaimerVoter.isStaffUserDisclaimerAccepted";
        session.setAttribute(sudSessionKey, Boolean.TRUE);
        
		int result = voter.vote(authentication, fi, attributes);
		Assert.assertEquals(AccessDecisionVoter.ACCESS_GRANTED, result);
    
	}
}
