package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import junit.framework.Assert;

import org.junit.Test;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;


public class PatientInPilotVoterTest extends AbstractVoterTest{

	@Test
	public void supportsDesiredConfigAccess(){
		Assert.assertTrue(supportsConfigAttribute("IS_PROVIDER_PATIENT_ADVOCATE", new PatientInPilotVoter<FilterInvocation>()));
	}

	@Test
	public void doesNotSupportsInvalidConfigAccess(){
		Assert.assertFalse(supportsConfigAttribute(Roles.ROLE_CONSUMER, new PatientInPilotVoter<FilterInvocation>()));
	}

	@Test
	public void canCreateFilterInvocation(){
		//Construct the filter invocation
		String assigningAuthority = "EDIPI";
		String patientId = "D123401";
		FilterInvocation fi = createFilterInvocation(assigningAuthority, patientId);
	
		//assert the generated uri has correct patient id info
		String uri = fi.getRequest().getRequestURI();
		PatientIdentifier targetPatientIdentifier = VoterHelper.getPatientIdentifierFromUri(uri);
		
		Assert.assertEquals(patientId, targetPatientIdentifier.getUniqueId());
		Assert.assertEquals(assigningAuthority, targetPatientIdentifier.getAssigningAuthority());
	}

	@Test
	public void deniesWhenPatientNotInPilot(){
		PatientInPilotVoter<FilterInvocation> voter = new PatientInPilotVoter<FilterInvocation>();
		List<GrantedAuthority> authorities = createPatientAuthorities();

		AppUser principal = createPrincipal("gallow.younger", new PatientIdentifier(defaultAssigningAuthority, defaultTargetPatientId), authorities);
		Object credentials = null;

		Authentication authentication = createAuthentication(authorities, principal, credentials);

		//Use knowledge of currently hard-coded list of patients that are in pilot program
		FilterInvocation fi = createFilterInvocation("EDIPI", "D123403");
		
		Collection<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
		
		int result = voter.vote(authentication, fi, attributes);
		
		Assert.assertEquals(AccessDecisionVoter.ACCESS_DENIED, result);
		
	}

	@Test 
	public void abstainsWhenPatientInPilot(){
		PatientInPilotVoter<FilterInvocation> voter = new PatientInPilotVoter<FilterInvocation>();
		List<GrantedAuthority> authorities = createPatientAuthorities();

		AppUser principal = createPrincipal("gallow.younger", new PatientIdentifier(defaultAssigningAuthority, defaultTargetPatientId), authorities);
		Object credentials = null;

		Authentication authentication = createAuthentication(authorities, principal, credentials);

		//Use knowledge of currently hard-coded list of patients that are in pilot program
		FilterInvocation fi = createFilterInvocation("EDIPI", "D123401");

		
		Collection<ConfigAttribute> attributes = new ArrayList<ConfigAttribute>();
		
		int result = voter.vote(authentication, fi, attributes);
		
		Assert.assertEquals(AccessDecisionVoter.ACCESS_ABSTAIN, result);
	}
	
	
}
