package com.agilex.healthcare.mobilehealthplatform.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.web.FilterInvocation;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;

public abstract class AbstractVoterTest extends SpringBasedIntegration {

	protected final String defaultTargetPatientId = "D123401";
    protected final String alternatePatientId = "DEF456";
    protected final String defaultAssigningAuthority = "EDIPI";

    protected boolean supportsConfigAttribute(String config, AccessDecisionVoter<FilterInvocation> decisionVoter) {
		AccessDecisionVoter<FilterInvocation> voter = decisionVoter;
		ConfigAttribute configAttribute = new SecurityConfig(config);
		return voter.supports(configAttribute);
	}

	protected FilterInvocation createFilterInvocation(String assigningAuthority, String patientId) {
		String servletPath = "/MobileHealthPlatformWeb";
		String pathInfo = "/rest/patient/" + assigningAuthority + "/" + patientId;

        ServletRequest request = createServletRequest(servletPath, pathInfo);
        ServletResponse response = createServletResponse();
        FilterChain chain = createFilterChain();
        FilterInvocation fi = new FilterInvocation(request, response, chain);
		return fi;
	}

    static final FilterChain DUMMY_CHAIN = new FilterChain() {
        public void doFilter(ServletRequest req, ServletResponse res) throws IOException, ServletException {
            throw new UnsupportedOperationException("Dummy filter chain");
        }
    };

    private FilterChain createFilterChain() {
        return DUMMY_CHAIN;
    }

    private ServletResponse createServletResponse() {
        return new VoterServletResponse();
    }

    private ServletRequest createServletRequest(String servletPath, String pathInfo) {
        ServletRequest request = new VoterServletRequest(null, servletPath, pathInfo, null, null);

        return request;  //To change body of created methods use File | Settings | File Templates.
    }

	protected List<GrantedAuthority> createPatientAuthorities() {
		return createAuthorities(Roles.ROLE_CONSUMER);
	}
	protected List<GrantedAuthority> createStaffAuthorities() {
		return createAuthorities(Roles.ROLE_STAFF);
	}
	
	protected List<GrantedAuthority> createAuthorities(String role) {
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		authorities.add(new SimpleGrantedAuthority(role));
		return authorities;
	}

	protected AppUser createPrincipal(String userName, PatientIdentifier patientIdentifier, List<GrantedAuthority> authorities) {
		String password = "";
		MhpUser authenticatedUser = new MhpUser();
        authenticatedUser.setUserIdentifier(patientIdentifier);
        authenticatedUser.setRightOfAccessAccepted(true);
		
		AppUser principal = new AppUser(userName, password, authorities, authenticatedUser);
		return principal;
	}
	
    protected UsernamePasswordAuthenticationToken createAuthentication(List<GrantedAuthority> authorities, AppUser principal, Object credentials) {
        return new UsernamePasswordAuthenticationToken(principal, credentials, authorities);
    }
}
