package com.agilex.healthcare.mobilehealthplatform.datalayer.staffuserdisclaimer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import javax.annotation.Resource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerContent;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffUserDisclaimerInfo;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import com.agilex.healthcare.utility.NullChecker;

//@Ignore
public class StaffUserDisclaimerDataServiceTest extends SpringBasedIntegration{
	StaffUserDisclaimerDataService dataService;
	
	@Resource
    private StaffUserDisclaimerDao dao;

	@Before
	public void setup() {
		StaffUserDisclaimerDataLayer datalayer = new StaffUserDisclaimerDataLayerRepo(dao);
		dataService = new StaffUserDisclaimerDataService(datalayer);
		dataService.saveStaffUserDisclaimerInfo(generateStaffUserDisclaimerInfo("TESTLOCATION", "TESTUSERTRUE", true));
		dataService.saveStaffUserDisclaimerInfo(generateStaffUserDisclaimerInfo("TESTLOCATION", "TESTUSERFALSE", false));
	}

	@Test
	public void verifyFetchOfStaffUserDisclaimerContent() {
		StaffUserDisclaimerContent content = dataService.getLatestStaffUserDisclaimerContent();
		assertNotNull(content);
		assertTrue(NullChecker.isNotNullish(content.getContent()));
		assertTrue(NullChecker.isNotNullish(content.getDate()));
	}

	@Test
	public void verifyFetchOfStaffUserDisclaimerInfoAccepted() {
		StaffUserDisclaimerInfo info = dataService.getStaffUserDisclaimerInfo("TESTLOCATION", "TESTUSERTRUE");
		assertEquals(true, info.isStaffUserDisclaimerAccepted());
	}

	@Test
	public void verifyFetchOfStaffUserDisclaimerInfoNotAccepted() {
		StaffUserDisclaimerInfo info = dataService.getStaffUserDisclaimerInfo("TESTLOCATION", "TESTUSERFALSE");
		assertEquals(false, info.isStaffUserDisclaimerAccepted());
	}

	@Test
	public void verifyFetchOfStaffUserDisclaimerInfoNonExistent() {
		boolean accepted = false;
		try {
			StaffUserDisclaimerInfo info = dataService.getStaffUserDisclaimerInfo("NONE", "NONE");
			accepted = (info == null) ? false : info.isStaffUserDisclaimerAccepted();
		} catch (WebApplicationException e) {
			if (e.getResponse().getStatus() == Status.PRECONDITION_FAILED.getStatusCode()) {
				accepted = true;
			}
		}

		assertEquals(false, accepted);
	}

	private StaffUserDisclaimerInfo generateStaffUserDisclaimerInfo(String vistaLocation, String userId, boolean accepted) {
		StaffUserDisclaimerInfo info = new StaffUserDisclaimerInfo();
		info.setStaffUserDisclaimerAccepted(accepted);
		info.setStaffUserDisclaimerDate(new Date());
		info.setUserId(userId);
		info.setVistaLocation(vistaLocation);

		return info;
	}
}
