package com.agilex.healthcare.mobilehealthplatform.datalayer.radiology;

import static org.junit.Assert.assertEquals;

import java.util.Calendar;
import java.util.GregorianCalendar;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResult;
import com.agilex.healthcare.mobilehealthplatform.domain.RadiologyResults;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.DateHelper;

@Ignore("TODO: ensure data consistency with MAE CDW")
public class RadiologyDataServiceTest extends SpringBasedIntegration{
	private static PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "D123401");
	private static PatientIdentifier healthyPatientIdentifier = new PatientIdentifier("EDIPI", "healthy");
	private static PatientIdentifier invalidPatientIdentifier = new PatientIdentifier("EDIPI", "XXXX");

	@Test
	public void retrieveList() {
		RadiologyDataService dataservice = new RadiologyDataService();
		RadiologyResults radiologyResults = dataservice.getRadiologyResults(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(22, radiologyResults.size());
	}

	@Test
	public void retrieveListWithDateFilter() {
		RadiologyDataService dataservice = new RadiologyDataService();
		RadiologyResults radiologyResults = dataservice.getRadiologyResults(patientIdentifier, DateFilterFactory.createFilterFromDate("1/1/2009", "12/31/2009"), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(2, radiologyResults.size());

		Calendar cal = new GregorianCalendar();
		for (RadiologyResult result : radiologyResults) {
			cal.setTime(result.getResultedDate());
			assertEquals(2009, cal.get(Calendar.YEAR));
		}
	}

	@Test
	public void retrieveListByPatientWithNoData() {
		RadiologyDataService dataservice = new RadiologyDataService();
		RadiologyResults radiologyResults = dataservice.getRadiologyResults(healthyPatientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(0, radiologyResults.size());
	}

	@Test
	public void retrieveListByInvalidPatient() {
		RadiologyDataService dataservice = new RadiologyDataService();
		RadiologyResults radiologyResults = dataservice.getRadiologyResults(invalidPatientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(0, radiologyResults.size());
	}

	//FIXME Test data issue with system identifier
	@Ignore
	public void retrieveSingle() {
		RadiologyDataService dataservice = new RadiologyDataService();
		RadiologyResult radiologyResult = dataservice.getRadiologyResult(patientIdentifier, new DataIdentifier("cdw", "2"));
		assertEquals(DateHelper.parseDate("7/1/2011"), radiologyResult.getDate());
	}
}
