package com.agilex.healthcare.mobilehealthplatform.datalayer.provider;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterImpl;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import com.agilex.healthcare.utility.DateHelper;

public class ProviderDataServiceTest extends SpringBasedIntegration {
	
	private final static PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowMockPatientIdentifier;
	private final static PatientIdentifier patientIdentifierWithNoData = PatientCorrelationMock.HealthyEnterprisePatientIdentifier;
	
	private ProviderDataService dataservice ;

	public ProviderDataServiceTest() {
		dataservice = new ProviderDataService();
	}

	@Test
	public void verifyValidPrimaryCareProvidersAreReturned() {
		PatientProviders providers = dataservice.fetchPrimaryCareProviders(patientIdentifier, "");
		assertEquals(2, providers.size());
	}

	@Test
	public void verifyValidMentalHealthProvidersAreReturned() {
		PatientProviders providers = dataservice.fetchMentalHealthProviders(patientIdentifier, DateFilterFactory.createEmptyFilter());
		assertEquals(4, providers.size());
	}

    @Ignore
	@Test
	public void verifyValidMentalHealthProvidersAreReturnedForSpecificDates() {
		DateFilterImpl dateFilter = new DateFilterImpl();
		Date today = DateHelper.getToday();
		dateFilter.setStartDate(DateHelper.minusMonths(today, 13));
		dateFilter.setEndDate(today);
		PatientProviders providers = dataservice.fetchMentalHealthProviders(patientIdentifier, dateFilter);
		assertEquals(2, providers.size());
	}

    @Ignore
	@Test
	public void verifyMentalHealthProvidersAreReturnedByDescendingOrderofVisit() {
        Date today = DateHelper.getToday();
        DateFilter dateFilter =  DateFilterFactory.createFilterFromDate(DateHelper.minusMonths(today, 13), today);
		PatientProviders providers = dataservice.fetchMentalHealthProviders(patientIdentifier, dateFilter);
		assertEquals("zztest appointment_provider4", providers.get(0).getProviderName());
		assertEquals("zztest appointment_provider3", providers.get(1).getProviderName());
		//assertEquals("zztest appointment_provider5", providers.get(2).getProviderName());
	}

	
	@Test
	public void verifyNoPrimaryCareProvidersAreReturnedForInvalidPatient() {
		PatientProviders providers = dataservice.fetchPrimaryCareProviders(patientIdentifierWithNoData, "");
		assertEquals(0, providers.size());
	}

	@Test
	public void verifyNoMentalHealthProvidersAreReturnedForInvalidPatient() {
		PatientProviders providers = dataservice.fetchMentalHealthProviders(patientIdentifierWithNoData, null);
		assertEquals(0, providers.size());
	}

}
