package com.agilex.healthcare.mobilehealthplatform.datalayer.problem;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.NullChecker;


@Ignore("TODO: ensure data consistency with MAE CDW")
public class ProblemDataServiceTest extends SpringBasedIntegration{
	private static PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "D123401");
	private static PatientIdentifier patientIdentifierWithNoData = new PatientIdentifier("EDIPI", "healthy");
	private static PatientIdentifier patientIdentifierWithNoCorrelations = new PatientIdentifier("EDIPI", "patientWithNoCorrelations");

	ProblemDataService dataservice = new ProblemDataService();

	@Test
	public void fetchListOfProblemsWithSingleResult() {
		Problems problems = dataservice.fetchProblems(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());

		assertEquals(3, problems.size());
	}

	@Test
	public void noResults() {
		Problems problems = dataservice.fetchProblems(patientIdentifierWithNoData, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(0, problems.size());
	}

	@Test
	public void noCorrelations() {
		Problems problems = dataservice.fetchProblems(patientIdentifierWithNoCorrelations, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(0, problems.size());
	}

	@Test
	public void fetchListContainsPatientIdentifier() {
		Problems problems = dataservice.fetchProblems(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertTrue(NullChecker.isNotNullish(problems.get(0).getPatientIdentifier().getUniqueId()));
		assertTrue(NullChecker.isNotNullish(problems.get(0).getPatientIdentifier().getAssigningAuthority()));
	}

	@Test
	public void fetchListContainsDataIdentifier() {
		Problems problems = dataservice.fetchProblems(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertNotNull(problems.get(0).getDataIdentifier());
		assertTrue(NullChecker.isNotNullish(problems.get(0).getDataIdentifier().getSystemId()));
		assertTrue(NullChecker.isNotNullish(problems.get(0).getDataIdentifier().getUniqueId()));
	}

	//FIXME Test data issue with system identifier
	@Ignore
	public void fetchSingleProblem() {
		Problem problem = dataservice.fetchProblem(patientIdentifier, new DataIdentifier("cdw", "2"));
		assertEquals("2", problem.getDataIdentifier().getUniqueId());
	}

	//FIXME Test data issue with system identifier
	@Ignore
	public void fetchSingleContainsPatientIdentifier() {
		PatientIdentifier localPatientIdentifier = new PatientIdentifier("EDIPI", "D123401");
		Problem problem = dataservice.fetchProblem(localPatientIdentifier, new DataIdentifier("cdw", "2"));
		assertEquals(localPatientIdentifier, problem.getPatientIdentifier());

		problem = dataservice.fetchProblem(patientIdentifier, new DataIdentifier("cdw", "2"));
		assertEquals(localPatientIdentifier, problem.getPatientIdentifier());
	}

	// @Test
	// public void fetchSingleContainsDataIdentifier() {
	// Problem problem = dataservice.fetchProblem(patientA, new
	// DataIdentifier("mock", "1"));
	// assertEquals(new DataIdentifier("mock", "1"),
	// problem.getDataIdentifier());
	// }

	//FIXME Test data issue with system identifier
	@Ignore
	public void retrieveSingleProblemNoResult() {
		PatientIdentifier localPatientIdentifier = new PatientIdentifier("EDIPI", "D123401");
		Problem problem = dataservice.fetchProblem(localPatientIdentifier, new DataIdentifier("cdw", "invalid"));
		assertNull(problem);
	}

	// private MhpObjectFactoryMock initializeMockSystems() {
	// ProblemDataLayer mockDataLayer = mock(ProblemDataLayer.class);
	//
	// Problems problemsToReturnForPatientA = new Problems();
	// Problem problem = new Problem();
	// problem.setUniqueId("1");
	// problem.setDescription("Backpain");
	// problem.setOnsetDate(DateHelper.parseDate("1/1/2001"));
	// problemsToReturnForPatientA.add(problem);
	// when(mockDataLayer.fetchProblems(eq(patientA.getUniqueId()))).thenReturn(problemsToReturnForPatientA);
	//
	// Problems problemsToReturnForPatientB = new Problems();
	// problem = new Problem();
	// problem.setUniqueId("2");
	// problem.setDescription("Headache");
	// problem.setOnsetDate(DateHelper.parseDate("1/1/2002"));
	// problemsToReturnForPatientB.add(problem);
	// problem = new Problem();
	// problem.setUniqueId("3");
	// problem.setDescription("Footache");
	// problem.setOnsetDate(DateHelper.parseDate("1/1/2003"));
	// problemsToReturnForPatientB.add(problem);
	// when(mockDataLayer.fetchProblems(eq(patientB.getUniqueId()))).thenReturn(problemsToReturnForPatientB);
	//
	// when(mockDataLayer.fetchProblems(eq(patientC.getUniqueId()))).thenReturn(new
	// Problems());
	// when(mockDataLayer.fetchProblems(eq(patientD.getUniqueId()))).thenReturn(null);
	//
	// MhpObjectFactoryMock mhpObjectFactory = new MhpObjectFactoryMock();
	// mhpObjectFactory.setBean("mock.problem.datalayer", mockDataLayer);
	//
	// PatientCorrelationEchoMock patientCorrelationServer = new
	// PatientCorrelationEchoMock();
	// mhpObjectFactory.setBean("patient-correlation",
	// patientCorrelationServer);
	// return mhpObjectFactory;
	// }
}
