package com.agilex.healthcare.mobilehealthplatform.datalayer.preference;

import static org.junit.Assert.assertNotNull;

import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;

//@Ignore
public class PatientPreferenceDataServiceTest extends SpringBasedIntegration{

	PatientPreferenceDataService dataservice = new PatientPreferenceDataService();
	PatientPreference patientPreference;
	String patientId;
	
	@Before
	public void before() {
		patientId = UUID.randomUUID().toString();
		patientPreference = updatePatientPreferenceObject(patientId);
	}
	
	@Test
	public void testFetchPreferenceForFirstTime() {
		PatientIdentifier patientIdentifier = createRandomPatientIdentifier();

		PatientPreference pref = dataservice.fetchPatientPreference(patientIdentifier);

		assertNotNull(pref);
	}

	@Test
	public void testCreatePatientPreference(){			
		PatientPreference patPref = dataservice.updatePatientPreference(patientPreference);		
		assertNotNull(patPref);		
		dataservice.deletePatientPreference(patientPreference);		
	}
	
	private PatientIdentifier createRandomPatientIdentifier() {
		return new PatientIdentifier("EDIPI", "D1234015");
	}
	
	public PatientPreference updatePatientPreferenceObject(String patientId){
		PatientPreference pref = new PatientPreference();
		PatientIdentifier pId = new PatientIdentifier();
		pId.setUniqueId(patientId);
		pref.setPatientId(patientId);
		pref.setNotificationFrequency("Each new message");
		pref.setEmailAddress("testPref1234_5@xyz.com");
		pref.setEmailAllowed(true);
		pref.setTextMsgAllowed(true);
		pref.setTextMsgPhNumber("(703) 123-4567");
		pref.setPatientIdentifier(pId);
		
		return pref;
	}
}
