package com.agilex.healthcare.mobilehealthplatform.datalayer.mood;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;
import org.junit.Ignore;

import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.MoodEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import com.agilex.healthcare.utility.DateHelper;

@Ignore("TODO: ensure data consistency with MAE CDW")
public class MoodEventDataServiceTest extends SpringBasedIntegration{

	@Test
	public void createItem() {
		MoodEvent moodEvent = new MoodEvent();
		moodEvent.setPatientIdentifier(PatientCorrelationMock.GallowEnterprisePatientIdentifier);
		moodEvent.setDate(DateHelper.parseDate("1/1/2011"));
		moodEvent.setValue("3");
		moodEvent.setNotes("note1");

		MoodEventDataService dataservice = new MoodEventDataService();
		MoodEvent savedEvent = dataservice.createData(moodEvent, ScopeFilter.getInstanceForLongitudinalScope());
		assertNotNull(savedEvent);
		assertNotNull(savedEvent.getDataIdentifier());
		System.out.println("saved " + savedEvent.getDataIdentifier());

		MoodEvent reLoadedMoodEvent = dataservice.fetchData(PatientCorrelationMock.GallowEnterprisePatientIdentifier, savedEvent.getDataIdentifier());
		assertNotNull(reLoadedMoodEvent);
	}

	@Test
	public void fetchList() {
		MoodEventDataService dataservice = new MoodEventDataService();
		MoodEvents moodEvents = dataservice.fetchDataList(PatientCorrelationMock.GallowEnterprisePatientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertTrue(moodEvents.size() > 0);
	}

	@Test
	public void fetchSingle() {
		MoodEventDataService dataservice = new MoodEventDataService();
		MoodEvents moodEvents = dataservice.fetchDataList(PatientCorrelationMock.GallowEnterprisePatientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		if (moodEvents.size() > 0) {
			MoodEvent moodEvent = dataservice.fetchData(PatientCorrelationMock.GallowEnterprisePatientIdentifier, new DataIdentifier("sed", moodEvents.getMoodEvent().iterator().next().getUniqueId()));
			assertNotNull(moodEvent);
			assertEquals("note1", moodEvent.getNotes());
		}
	}

	@Test
	public void fetchSingleWithNoResults() {
		MoodEventDataService dataservice = new MoodEventDataService();
		MoodEvent moodEvent = dataservice.fetchData(PatientCorrelationMock.GallowEnterprisePatientIdentifier, new DataIdentifier("sed", "invalid"));
		assertNull(moodEvent);
	}

	@Test
	public void updateItem() {
		MoodEventDataService dataservice = new MoodEventDataService();
		MoodEvents moodEvents = dataservice.fetchDataList(PatientCorrelationMock.GallowEnterprisePatientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		MoodEvent moodEvent = null;
		if (moodEvents.size() > 0) {
			moodEvent = dataservice.fetchData(PatientCorrelationMock.GallowEnterprisePatientIdentifier, new DataIdentifier("sed",  moodEvents.getMoodEvent().iterator().next().getUniqueId()));
			moodEvent.setNotes("modified by unit test");
			dataservice.updateData(moodEvent);
		}
		MoodEvent reLoadedMoodEvent = dataservice.fetchData(PatientCorrelationMock.GallowEnterprisePatientIdentifier, new DataIdentifier("sed", moodEvent.getUniqueId()));
		assertEquals("modified by unit test", reLoadedMoodEvent.getNotes());
	}

	@Test
	public void deleteItem() {
		MoodEventDataService dataservice = new MoodEventDataService();
		MoodEvents moodEvents = dataservice.fetchDataList(PatientCorrelationMock.GallowEnterprisePatientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		MoodEvent moodEvent = null;
		if (moodEvents.size() > 0) {
			moodEvent = dataservice.fetchData(PatientCorrelationMock.GallowEnterprisePatientIdentifier, new DataIdentifier("sed",  moodEvents.getMoodEvent().iterator().next().getUniqueId()));
			assertNotNull(moodEvent);
			dataservice.deleteData(moodEvent);
		}
		moodEvent = dataservice.fetchData(PatientCorrelationMock.GallowEnterprisePatientIdentifier, new DataIdentifier("sed", moodEvent.getUniqueId()));
		assertNull(moodEvent);
	}

}
