package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import javax.annotation.Resource;

import junit.framework.Assert;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import com.agilex.healthcare.mobilehealthplatform.utils.PropertyHelper;


public class FetchRefillableMedicationRequestHandlerTest extends SpringBasedIntegration {
	@Resource
	PropertyHelper propertyHelper;
	FetchRefillableMedicationsRequestHandler handler = null;
	
	@Before
	public void before() {
		handler = new FetchRefillableMedicationsRequestHandler(propertyHelper);
	}
	
	@Test
	public void propertyHelperSet() {
		Assert.assertNotNull(propertyHelper);
		
		String supportedSites = propertyHelper.getProperty(FetchRefillableMedicationsRequestHandler.SUPPORTED_SITES_PROPERTY);
		Assert.assertNotNull(supportedSites);
	}
	
	@Test
	public void testValidPatientIdentifiers() {
		PatientIdentifier validIdentifier = new PatientIdentifier("ICN-688", "not relevant");
		PatientIdentifiers patientIdentifiers = new PatientIdentifiers();
		patientIdentifiers.add(validIdentifier);
		
		Assert.assertTrue(handler.supportedIdentifiers(patientIdentifiers).size() == 1);
	}
	
	@Test
	public void testInvalidPatientIdentifiers() {
		PatientIdentifier invalidIdentifier = new PatientIdentifier("ICN-500", "not relevant");
		PatientIdentifiers patientIdentifiers = new PatientIdentifiers();
		patientIdentifiers.add(invalidIdentifier);
		
		Assert.assertTrue(handler.supportedIdentifiers(patientIdentifiers).size() == 0);
	}
}
