package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import static org.junit.Assert.assertTrue;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro.MicrobiologyLabDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class RetrieveMicrobiologyLabResultsByTestIdTest extends SpringBasedIntegration{

	PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;
	private ScopeFilter scopeFilter = ScopeFilter.getInstanceForLongitudinalScope();
	private DateFilter dateFilter = DateFilterFactory.createEmptyFilter();

	@Test
	public void getLabResultsByTestId() {
		MicrobiologyLabDataService dataservice = new MicrobiologyLabDataService();
		// String patientId = "D123401";
		LabResults labResults = dataservice.getLabResults(patientIdentifier, dateFilter, scopeFilter);

		assertTrue(labResults.size() >= 7);
		assertTrue(labResults.get(0).getSpecimenId().trim().equals("70"));
	}
}
