package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import static junit.framework.Assert.assertTrue;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroup;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
@Ignore
public class LabTestGroupsIntegrationTest {
	PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;

	ChemistryLabDataService dataservice = new ChemistryLabDataService();

	// LinkedHashSet guarantees insertion-order and is unique
	static Set<String> expectedGroupNamesOrder = new LinkedHashSet<String>();

	static Set<String> expectedLabTestsOrder = new LinkedHashSet<String>();

	@BeforeClass
	public static void init() {
		expectedGroupNamesOrder.add("CBC PROFILE");
		expectedGroupNamesOrder.add("CELL COUNT (CSF)");
		expectedGroupNamesOrder.add("CELL COUNT (SYNOVIAL)");
		expectedGroupNamesOrder.add("CELL COUNT (PLEURAL)");
		expectedGroupNamesOrder.add("CELL COUNT (PERITONEAL)");
		expectedGroupNamesOrder.add("CELL COUNT (PERICARD/THORACIC)");
		expectedGroupNamesOrder.add("Miscellaneous Tests");

		expectedLabTestsOrder.add("2");
	}

	/*
	 * under this test for patient_id=D123401, the order of groups for the based
	 * on the config must be as follow: CBC PROFILE CELL COUNT (CSF) CELL COUNT
	 * (SYNOVIAL) CELL COUNT (PLEURAL) CELL COUNT (PERITONEAL) CELL COUNT
	 * (PERICARD/THORACIC)
	 */

	@Ignore
	public void verifyGroupOrdersForThisPatient() {

		LabTestGroups labGroupsFromLabTests = getLabTestsInGroupForPatient(patientIdentifier);

		Set<String> returnedGroupsOrder = new LinkedHashSet<String>();

		for (LabTestGroup labTestGroup : labGroupsFromLabTests) {

			returnedGroupsOrder.add(labTestGroup.getName());
		}

		assertTrue(expectedGroupNamesOrder.equals(returnedGroupsOrder));

	}

	@Test
	public void verifyNoDuplicateGroups() {

		LabTestGroups groups = getLabTestsInGroupForPatient(patientIdentifier);
		List<LabTestGroup> list = new ArrayList<LabTestGroup>();

		for (LabTestGroup group : groups) {
			assertTrue("Duplicate Groups!", !list.contains(group));
			list.add(group);
		}

	}

	@Test
	public void verifyNoDuplicateLabsInGroups() {

		// Note we are explicitly calling data layer twice to make sure it
		// doesn't create dups
		LabTestGroups groups = getLabTestsInGroupForPatient(patientIdentifier);
		groups = getLabTestsInGroupForPatient(patientIdentifier);

		List<LabTestGroup> list = new ArrayList<LabTestGroup>();

		for (LabTestGroup group : groups) {

			List<String> labTestIds = new ArrayList<String>();

			LabTests labTests = group.getLabTests();

			for (LabTest labTest : labTests) {

				assertTrue("Duplicate found!", !labTestIds.contains(labTest.getUniqueId()));

				labTestIds.add(labTest.getUniqueId());

			}

			assertTrue("Duplicate Groups!", !list.contains(group));

			list.add(group);

		}

	}

	private LabTestGroups getLabTestsInGroupForPatient(PatientIdentifier patientIdentifier) {

		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		ScopeFilter scopeFilter = ScopeFilter.getInstanceForLongitudinalScope();
		LabTests labTests = dataservice.getLabTestsWithMostRecentResult(patientIdentifier, dateFilter, scopeFilter);

		LabTestGroups labGroupsFromLabTests = dataservice.extractAndSortLabGroupsByLabTests(labTests);

		return labGroupsFromLabTests;
	}

}
