package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import java.util.*;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import com.agilex.healthcare.utility.ModeHelper;

public class ChemistryLabGrouperTest extends SpringBasedIntegration {

	private static ChemistryLabGrouper grouper;

	@BeforeClass
	public static void checkWhetherTestsAreRunningInVaVeteranDevMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "va-provider-dev"));
		grouper = new ChemistryLabGrouper();
	}

	@Test
	public void verifyLoading() {
		Assert.assertNotNull(grouper);
	}

	@Test
	public void verifySimpleGrouping() {
		LabTests tests = oneOfEach();

		LabTestGroups groups = grouper.group(tests);

		for (LabTestGroup group : groups) {
			Assert.assertEquals(1, group.getLabTests().size());
		}
	}
	
	@Test
	public void verifyTestUngrouped() {
		LabTests tests = new LabTests();
		LabTest labTest = new LabTest();
		labTest.setTestname("test1");
		tests.add(labTest);
		
		LabTestGroups grouped = grouper.group(tests);
		
		for(LabTestGroup group : grouped) {
			if(group.getName().equals("ungrouped")) {
				Assert.assertEquals(1,  group.getLabTests().size());
			} else {
				Assert.assertEquals(0, group.getLabTests().size());
			}
		}
		
	}

	@Test
	public void validateMapMostRecentWithLoinc() {
		LabTests labTests = new LabTests();
		Map<String, LabTests> mappedTests = new HashMap<String, LabTests>();
		
		LabTest labTest = new LabTest();
		labTest.setTestname("test1");
		labTest.setLoinc("6690-2");
		labTests.add(labTest);
		
		labTest = new LabTest();
		labTest.setTestname("test2");
		labTest.setLoinc("6690-2");
		labTests.add(labTest);

		mappedTests.put("6690-2", labTests);
		
		labTests = new LabTests();
		labTest = new LabTest();
		labTest.setTestname("test3");
		labTest.setLoinc("2339-0");
		labTests.add(labTest);
		
		mappedTests.put("2339-0", labTests);
		
		Map<String, LabTest> mostRecent = grouper.mapMostRecent(mappedTests);
		Assert.assertEquals(2, mostRecent.keySet().size());
		Assert.assertEquals("test1", mostRecent.get("6690-2").getDisplayName());
		Assert.assertEquals("test3", mostRecent.get("2339-0").getDisplayName());
	}
	
	@Test
	public void validateMapMostRecentWithTestName() {
		LabTests labTests = new LabTests();
		Map<String, LabTests> mappedTests = new HashMap<String, LabTests>();
		
		LabTest labTest = new LabTest();
		labTest.setTestname("test1");
		labTests.add(labTest);
		
		labTest = new LabTest();
		labTest.setTestname("test2");
		labTests.add(labTest);

		mappedTests.put("6690-2", labTests);
		
		labTests = new LabTests();
		labTest = new LabTest();
		labTest.setTestname("test3");
		labTests.add(labTest);
		
		mappedTests.put("2339-0", labTests);
		
		Map<String, LabTest> mostRecent = grouper.mapMostRecent(mappedTests);
		Assert.assertEquals(2, mostRecent.keySet().size());
		Assert.assertEquals("test1", mostRecent.get("6690-2").getDisplayName());
		Assert.assertEquals("test3", mostRecent.get("2339-0").getDisplayName());
	}
	
	@Test
	public void validateMapMostRecentWithTestAndSpecimen() {
		LabTests labTests = new LabTests();
		Map<String, LabTests> mappedTests = new HashMap<String, LabTests>();
		
		LabTest labTest = new LabTest();
		labTest.setTestname("test1");
		labTest.setUniqueId("1");
		labTest.setSpecimenId("3");
		labTests.add(labTest);
		
		labTest = new LabTest();
		labTest.setTestname("test2");
		labTest.setUniqueId("1");
		labTest.setSpecimenId("3");
		labTests.add(labTest);

		mappedTests.put("6690-2", labTests);
		
		labTests = new LabTests();
		labTest = new LabTest();
		labTest.setTestname("test3");
		labTest.setUniqueId("2");
		labTest.setSpecimenId("3");
		labTests.add(labTest);
		
		mappedTests.put("2339-0", labTests);
		
		Map<String, LabTest> mostRecent = grouper.mapMostRecent(mappedTests);
		Assert.assertEquals(2, mostRecent.keySet().size());
		Assert.assertEquals("test1", mostRecent.get("6690-2").getDisplayName());
		Assert.assertEquals("test3", mostRecent.get("2339-0").getDisplayName());
	}
	
	@Test
	public void verifyOrderingOfGroup() {
		LabTests tests = cbcTests();

		LabTestGroups groups = grouper.group(tests);

		Assert.assertEquals(8, groups.size());

		LabTestGroup cbcGroup = groups.get(0);
		LabTests cbcTests = cbcGroup.getLabTests();
		Assert.assertEquals(4, cbcTests.size());

		Assert.assertEquals("6690-2", cbcTests.get(0).getLoinc());
	}

	public LabTests oneOfEach() {
		LabTests tests = new LabTests();

		LabTest test = new LabTest();
		test.setLoinc("6690-2");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("2339-0");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("2093-3");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("34714-6");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("4548-4");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("31019-3");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("2143-6");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("2132-9");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("no-match");
		tests.add(test);

		return tests;
	}

	private LabTests cbcTests() {
		LabTests tests = new LabTests();

		LabTest test = new LabTest();
		test.setLoinc("6690-2");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("804-5");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("718-7");
		tests.add(test);

		test = new LabTest();
		test.setLoinc("26464-8");
		tests.add(test);

		return tests;
	}
}
