package com.agilex.healthcare.mobilehealthplatform.datalayer.lab;

import static org.junit.Assert.*;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Test;
import org.junit.Ignore;

import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.micro.MicrobiologyLabDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.*;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

@Ignore("TODO: ensure data consistency with MAE CDW")
public class ChemistryLabDataServiceTest extends SpringBasedIntegration{
	private final ScopeFilter scopeFilter = ScopeFilter.getInstanceForLongitudinalScope();

	@Test
	public void retrieve() {
		ChemistryLabDataService dataservice = new ChemistryLabDataService();
		PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;
		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		LabResults retrievedLabResults = dataservice.getLabResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());

		assertResultExists(retrievedLabResults, "1", "2345-7");
		assertResultDoesNotExists(retrievedLabResults, "1", "invalid");
	}

	@Test
	public void retrieveWithDate() {
		ChemistryLabDataService dataservice = new ChemistryLabDataService();
		PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate("5/1/2012", "5/5/2012");
		LabResults retrievedLabResults = dataservice.getLabResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());

		assertResultDoesNotExists(retrievedLabResults, "1", "2345-7");
	}

	@Test
	public void retrieveByTest() {
		ChemistryLabDataService dataservice = new ChemistryLabDataService();
		PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;
		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		String loinc = "2345-7";
		LabResults retrievedLabResults = dataservice.getLabResults(patientIdentifier, loinc, dateFilter, scopeFilter);

		assertResultExists(retrievedLabResults, "1", "2345-7");
		assertTrue(210 >= retrievedLabResults.size());
	}

	@Test
	public void ensureFilteringDoesNotAffectNextCall() {
		ChemistryLabDataService dataservice = new ChemistryLabDataService();
		PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;

		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		LabResults labResults = dataservice.getLabResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
		assertTrue(labResults.size() > 0);

		String loinc = "2345-7";
		dateFilter = DateFilterFactory.createFilterFromDate("5/15/2012", "5/17/2012");
		labResults = dataservice.getLabResults(patientIdentifier, loinc, dateFilter, scopeFilter);
		assertTrue(labResults.size() > 0);

		dateFilter = DateFilterFactory.createEmptyFilter();
		labResults = dataservice.getLabResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
		assertTrue(labResults.size() > 0);
	}

	private void assertResultExists(LabResults retrievedLabResults, String accessionNumber, String loinc) {
		LabResult match = null;
		for (LabResult retrievedResult : retrievedLabResults) {
			if (retrievedResult.getLoinc().contentEquals(loinc) && retrievedResult.getAccessionNumber().contentEquals(accessionNumber))
				match = retrievedResult;
		}
		assertNotNull(match);
	}

	private void assertResultDoesNotExists(LabResults retrievedLabResults, String accessionNumber, String loinc) {
		LabResult match = null;
		for (LabResult retrievedResult : retrievedLabResults) {
			if (retrievedResult.getLoinc().contentEquals(loinc) && retrievedResult.getAccessionNumber().contentEquals(accessionNumber))
				match = retrievedResult;
		}
		assertNull(match);
	}

	@Test
	public void retrieveChemThenMicroThenChem() {
		ChemistryLabDataService dataservice = new ChemistryLabDataService();
		PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;
		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();

		LabResults retrievedLabResults = dataservice.getLabResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
		assertResultExists(retrievedLabResults, "1", "2345-7");

		MicrobiologyLabDataService microDataService = new MicrobiologyLabDataService();
		microDataService.getLabResultsWithTextResults(patientIdentifier, dateFilter, scopeFilter);

		retrievedLabResults = dataservice.getLabResults(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
		assertResultExists(retrievedLabResults, "1", "2345-7");
	}
}
