package com.agilex.healthcare.mobilehealthplatform.datalayer.feedback;

import static org.junit.Assert.assertNotNull;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentProcessedAsPerUserNeed;
import com.agilex.healthcare.mobilehealthplatform.domain.UserFeedback;
import com.agilex.healthcare.mobilehealthplatform.restservice.exception.InvalidUserFeedbackException;

public class UserFeedbackDataServiceTest extends SpringBasedIntegration{

	UserFeedbackDataService service = new UserFeedbackDataService();
	
	@Test
	public void validateUserFeedbackIsSaved(){
		UserFeedback userFeedback = new UserFeedback();
		userFeedback.setComments("Appointment Request was processed very quickly");
		userFeedback.setRecommendationRating(new Integer(5));
		userFeedback.setAppointmentProcessedAsPerUserNeed(AppointmentProcessedAsPerUserNeed.Always);
		userFeedback = service.saveUserFeedback(userFeedback);
		assertNotNull(userFeedback.getUniqueId());
	}
	
	@Test(expected=InvalidUserFeedbackException.class)
	public void validateUserFeedbackSaveWithNullValue(){
		service.saveUserFeedback(null);
	}
	
	@Test(expected=InvalidUserFeedbackException.class)
	public void validateUserFeedbackSaveWithNullUserSatisfaction(){
		UserFeedback userFeedback = new UserFeedback();
		userFeedback.setComments("Appointment Request was processed very quickly");
		userFeedback.setRecommendationRating(new Integer(5));
		userFeedback = service.saveUserFeedback(userFeedback);
	}

	@Test(expected=InvalidUserFeedbackException.class)
	public void validateUserFeedbackSaveWithNullRecommendationRating(){
		UserFeedback userFeedback = new UserFeedback();
		userFeedback.setComments("Appointment Request was processed very quickly");
		userFeedback.setAppointmentProcessedAsPerUserNeed(AppointmentProcessedAsPerUserNeed.Never);
		userFeedback = service.saveUserFeedback(userFeedback);
	}

}
