package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.LinkedList;
import java.util.List;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.Ignore;

import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;

@Ignore("TODO: ensure data consistency with MAE CDW")
public class FacilityDataServiceTest extends SpringBasedIntegration {
	private FacilityDataService service = new FacilityDataService();

	private static List<String> pilotSites = new LinkedList<String>();

	@BeforeClass
	public static void init() {
		pilotSites.add("688");
	}

	@Test
	public void validateFacilityFilter(){
		FacilityFilterFactory factory = new FacilityFilterFactory(pilotSites);
		Facilities facilities = service.fetchFacilities(factory.createEmptyFacilityFilter());

		assertNotNull(facilities);
		assertTrue(facilities.size() > 0);

		for (Facility facility : facilities) {
			assertEquals("688", facility.getParentSiteCode());
		}
	}


	@Test
	public void validateFetchFacilityByValidCode(){
		Facility facility = service.fetchFacilityByCode(pilotSites, "590");

		assertEquals("688", facility.getParentSiteCode());
		assertEquals("590", facility.getFacilityCode());
	}


	@Test
	public void validateFetchFacilityByValidName(){
		Facility facility = service.fetchFacilityByName(pilotSites, "Hampton (VAMC)");

		assertEquals("688", facility.getParentSiteCode());
		assertEquals("Hampton (VAMC)", facility.getName());
	}


	@Test
	public void validateFetchFacilityByCodeNotInPilot(){
		try {
			Facility facility = service.fetchFacilityByCode(pilotSites, "537");
			assertNull(facility);
		} catch (WebApplicationException e) {
			if (e.getResponse().getStatus() != Status.NOT_FOUND.getStatusCode()) {
				fail("Unexpected status");
			}
		}
	}


	@Test
	public void validateFetchFacilityByNameNotInPilot(){
		try {
			Facility facility = service.fetchFacilityByName(pilotSites, "Jesse Brown VAMC");
			assertNull(facility);
		} catch (WebApplicationException e) {
			if (e.getResponse().getStatus() != Status.NOT_FOUND.getStatusCode()) {
				fail("Unexpected status");
			}
		}
	}
}
