package com.agilex.healthcare.mobilehealthplatform.datalayer.facility;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;
import org.junit.Ignore;

import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;

public class FacilityCacheTest extends SpringBasedIntegration {

	private FacilityFilterFactory facilityFilterFactory;
	private FacilityFilter filterA;
	private FacilityFilter filterB;
	private FacilityCache cache;

	@Before
	public void setup() {
		facilityFilterFactory = new FacilityFilterFactory(null);
		filterA = facilityFilterFactory.createEmptyFacilityFilter();
		filterB = facilityFilterFactory.createEmptyFacilityFilter();
		cache = FacilityCache.getInstance();
	}

  @Ignore("TODO: ensure data consistency with MAE CDW")
	@Test
	public void testCacheLoad() {
		assertEquals("expected missing facility to return code","ZZZZ",cache.getFacilityName("ZZZZ"));
		assertEquals("expected code 688 to be facility DC VAMC","DC VAMC",cache.getFacilityName("688"));
	}

	@Test
	public void testDuplicateFilter() {
		filterA.setTerm("term");
		Facilities facilities = new Facilities();

		facilities.add(createFacility("code","va from hell"));

		cache.addFacilitiesToCache(filterA, facilities);
		assertEquals("va from hell",cache.getFacilityName("code"));

		filterB.setTerm("term"); // equivalent to other filter
		assertTrue(filterA.getKeyForCache().equals(filterB.getKeyForCache()));

		// test that cache does not grow needlessly, but that the names do get updated
		facilities.get(0).setName("va from heaven");

		long size = cache.getFacilityObjMapSize();
		cache.addFacilitiesToCache(filterB, facilities);
		assertEquals("va from heaven",cache.getFacilityName("code"));
		assertTrue("don't expect the map to grow", size==cache.getFacilityObjMapSize());
	}

	@Test
	public void testObjMap() {
		filterA.setTerm("term");
		filterB.setTerm("term");

		Facilities facilities = new Facilities();
		facilities.add(createFacility("code","name"));

		cache.addFacilitiesToCache(filterA, facilities);

		assertNotNull(cache.getFacilities(filterA));
		assertTrue(cache.getFacilities(filterA).size()==1);

		// filterB should be treated equally to filterA
		assertNotNull(cache.getFacilities(filterB));
		assertTrue(cache.getFacilities(filterB).size()==1);

		filterB.setParentFacilitiesOnly(!filterB.isParentFacilitiesOnly());
		assertNull(cache.getFacilities(filterB));
	}

	private Facility createFacility(String code, String name) {
		Facility facility = new Facility();
		facility.setFacilityCode(code);
		facility.setName(name);
		return facility;
	}
}
