package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;

public class RequestMessageTest {

	@Test
	public void accessKeyValueAsString() {
		RequestMessage request = new RequestMessage();
		request.setValue("k", "v");
		String actualValue = request.getValue("k");
		assertEquals("v", actualValue);
	}

	@Test
	public void readKeyValueReadsLastValueSet() {
		RequestMessage request = new RequestMessage();
		request.setValue("k", "v1");
		request.setValue("k", "v2");
		String actualValue = request.getValue("k");
		assertEquals("v2", actualValue);
	}

	@Test
	public void readKeyValueWithoutSetResultsInNull() {
		RequestMessage request = new RequestMessage();
		String actualValue = request.getValue("k");
		assertEquals(null, actualValue);
	}

	@Test
	public void accessKeyValueAsDate() {
		RequestMessage request = new RequestMessage();
		request.setValue("k", DateHelper.parseDate("1/1/2000"));
		Date actualValue = request.getValue("k");
		assertEquals(DateHelper.parseDate("1/1/2000"), actualValue);
	}

	@Test
	public void idIsSetAutomatically() {
		RequestMessage request = new RequestMessage();
		if (NullChecker.isNullish(request.getMessageId()))
			fail();
	}
}
