package com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.RequestMessage;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.Router;
import com.agilex.healthcare.mobilehealthplatform.datalayer.dataretriever.router.patientdata.PatientDataFetchRequestBuilder;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.Domain;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class RouterTest extends SpringBasedIntegration{

	@Test
	public void invokeRouterWithoutError() {
		Router router = new Router();

		PatientDataFetchRequestBuilder builder = PatientDataFetchRequestBuilder.forRetrieveList();
		builder.forDomain(Domain.allergy).forPatientIdentifier(new PatientIdentifier("EDIPI", "EDIPI-1")).forScopeFilter(ScopeFilter.getInstanceForLongitudinalScope());
		RequestMessage request = builder.build();

		router.execute(request);
	}

}
