package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.DateHelper;

public class CalendarEventDataServiceTest extends SpringBasedIntegration{

	@Test
	public void testSaveCalendarEvent() {
		PatientIdentifier patientIdentifier = createRandomPatientIdentifier();
		CalendarEvent calendarEvent = createBasicCalendarEvent(patientIdentifier);

		CalendarEventDataService dataservice = new CalendarEventDataService();
		CalendarEvent savedCalendarEvent = dataservice.saveCalendarEvent(calendarEvent, ScopeFilter.getInstanceForLongitudinalScope());

		assertNotNull(savedCalendarEvent);
		assertNotNull(savedCalendarEvent.getUniqueId());
		assertEquals(calendarEvent.getTitle(), savedCalendarEvent.getTitle());
		assertEquals(new Integer(5), savedCalendarEvent.getAlertDuration());
		assertEquals(new Integer(0), savedCalendarEvent.getDuration());

		CalendarEvents retrieved = dataservice.getCalendarEvents(patientIdentifier, ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(1, retrieved.size());
	}

	private CalendarEvent createBasicCalendarEvent(PatientIdentifier patientIdentifier) {
		CalendarEvent calendarEvent = new CalendarEvent();
		calendarEvent.setTitle("Test Calendar Title");
		calendarEvent.setNotes("Test Calendar Notes");
		calendarEvent.setStartDate(DateHelper.getTomorrow());
		calendarEvent.setAlertDuration(5);
		calendarEvent.setPatientIdentifier(patientIdentifier);

		return calendarEvent;
	}

	private PatientIdentifier createRandomPatientIdentifier() {
		return new PatientIdentifier("EDIPI", UUID.randomUUID().toString());
	}
}
