package com.agilex.healthcare.mobilehealthplatform.datalayer.calendar;

import static org.junit.Assert.assertTrue;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;

public class CalendarDataServiceTest extends SpringBasedIntegration{
	PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "D123401");

	@Test
	public void retrieverCalendar() {
		CalendarDataService dataservice = new CalendarDataService();
		String calendarEvents = dataservice.getAggregatedPatientCalendar(patientIdentifier, DateFilterFactory.createEmptyFilter());
		assertTrue(calendarEvents.length() > 0);
	}
}
