package com.agilex.healthcare.mobilehealthplatform.datalayer.assessmentresults;

import static org.junit.Assert.*;

import java.util.Date;

import junit.framework.Assert;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResponses;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResult;
import com.agilex.healthcare.mobilehealthplatform.domain.AssessmentResults;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssessmentCode;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class MergePclAssessmentResultsTest extends SpringBasedIntegration{
	private static final String PTSD = "ptsd";
	private static final PatientIdentifier gallow = PatientCorrelationMock.GallowMockPatientIdentifier;
	private static ScopeFilter scope = ScopeFilter.getInstanceForLongitudinalScope();

	@Before
	public void setup() {
		saveResult(createResult(gallow, PTSD));
	}

	@Test
	public void fetchAssessmentResults() {
		AssessmentResultsDataService dataservice = new AssessmentResultsDataService();
		AssessmentResults assessmentResults = dataservice.fetchResultsByAssessment(gallow, PTSD, DateFilterFactory.createEmptyFilter(), scope);
		Assert.assertTrue(assessmentResults.size() > 0);
	}

	private AssessmentResult saveResult(AssessmentResult assessmentResult) {
		AssessmentResultsDataService dataservice = new AssessmentResultsDataService();
		return dataservice.saveResult(assessmentResult, scope);
	}

	private AssessmentResult createResult(PatientIdentifier patientIdentifier, String assessmentId) {
		AssessmentResult assessmentResult = new AssessmentResult();
		assessmentResult.setUniqueTitle("testUniqueTitle");
		assessmentResult.setVersion("1.0");
		assessmentResult.setAuthenticationStrategy(AssessmentCode.AUTHENTICATION_STRATEGY_BASIC);
		assessmentResult.setNotes("This assessment came from the DataServiceTest.");
		assessmentResult.setAssessmentId(assessmentId);
		assessmentResult.setPatientIdentifier(patientIdentifier);
		assessmentResult.setDateTaken(new Date());
		assessmentResult.setInProgress(false);
		assessmentResult.setScoringAlgorithm(AssessmentCode.SCORING_ALGORITHM_UNSCORED);
		assessmentResult.setWaitingPeriod(7);
		assessmentResult.setPatientIdentifier(patientIdentifier);

		AssessmentResponses responses = new AssessmentResponses();
		assessmentResult.setResponses(responses);

		return assessmentResult;
	}

}
