package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentMetric;
import com.agilex.healthcare.mobilehealthplatform.enumeration.AppointmentMetrics;
import com.agilex.healthcare.utility.ModeHelper;

public class AppointmentMetricsDataServiceTest extends SpringBasedIntegration{
	private AppointmentMetricsDataService dataservice;
	
	public AppointmentMetricsDataServiceTest() {
		dataservice = new AppointmentMetricsDataService();
	}

	@BeforeClass
	public static void init() {
		Assume.assumeTrue(ModeHelper.isMode("dev"));
	}
	
	@Test
	public void testIncrementNoIcnOrDfn() {
		testMetric(AppointmentMetrics.NO_ICN_OR_DFN.getName());
	}
	
	@Test
	public void testNoDfnCancelRequest() {
		testMetric(AppointmentMetrics.NO_DFN_CANCEL_REQUEST.getName());
	}
	
	private void testMetric(String name) {
		AppointmentMetric metric = dataservice.incrementMetric(name);
		int value1 = metric.getValue();
		assertTrue(value1 > 0);
		
		metric = dataservice.incrementMetric(name);
		int value2 = metric.getValue();
		
		assertEquals(value1 + 1, value2);
	}
}
