package com.agilex.healthcare.mobilehealthplatform.datalayer.appointment;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Test;
import org.junit.Ignore;

import com.agilex.healthcare.mobilehealthplatform.domain.Appointment;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.patientcorrelation.PatientCorrelationMock;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import com.agilex.healthcare.utility.DateHelper;

public class AppointmentDataServiceTest extends SpringBasedIntegration{
	private final static PatientIdentifier patientIdentifier = PatientCorrelationMock.GallowEnterprisePatientIdentifier;
	private final static PatientIdentifier patientIdentifierWithNoData = PatientCorrelationMock.HealthyEnterprisePatientIdentifier;

	private AppointmentDataService dataservice = new AppointmentDataService();

	@Ignore("TODO: ensure data consistency with MAE CDW")
	@Test
	public void fetchAppointments() {
		String startDate = "1/10/2012";
		String endDate = "1/20/2012";

		DateFilter dateFilter = DateFilterFactory.createFilterFromDate(startDate, endDate);
		Appointments appointments = dataservice.getPatientAppointments(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());

		assertEquals(4, appointments.size());

		for (Appointment appointment : appointments) {
			assertTrue(appointment.getAppointmentStartDate().after(DateHelper.parseDate(startDate)));
			assertTrue(appointment.getAppointmentStartDate().before(DateHelper.parseDate(endDate)));
		}
	}

	@Test
	public void fetchListOfAppointmentsReturnsEmpty() {
		DateFilter dateFilter = DateFilterFactory.createEmptyFilter();
		Appointments Appointments = dataservice.getPatientAppointments(patientIdentifierWithNoData, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(0, Appointments.size());
	}

	@Test
	public void fetchListOfAppointmentsDateFilter() {
		DateFilter dateFilter = DateFilterFactory.createFilterFromDate("1/1/2000", "1/1/2000");
		Appointments Appointments = dataservice.getPatientAppointments(patientIdentifier, dateFilter, ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(0, Appointments.size());
	}

}
