package com.agilex.healthcare.mobilehealthplatform.datalayer.allergy;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public class AllergyDataServiceTest extends SpringBasedIntegration{
	private static PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "D123401");

	@Test
	public void retrieveAllergiesContainData() {
		AllergyDataService dataService = new AllergyDataService();
		Allergies allergies = dataService.fetchPatientAllergies(patientIdentifier);
		assertNotNull(allergies);
		assertTrue(allergies.size() >= 1);
	}

	private Allergy getTestAllergyFromGetAllAllergies(PatientIdentifier patientIdentifier) {
		AllergyDataService dataService = new AllergyDataService();
		Allergies allergies = dataService.fetchPatientAllergies(patientIdentifier);
		assertNotNull(allergies);
		assertTrue(allergies.size() >= 1);
		return allergies.get(0);
	}

	@Test
	public void retrieveAllergiesContainsAllergyId() {
		Allergy allergy = getTestAllergyFromGetAllAllergies(patientIdentifier);
		assertEquals("3", allergy.getUniqueId());
	}

	@Test
	public void retrieveAllergiesContainsCategory() {
		Allergy allergy = getTestAllergyFromGetAllAllergies(patientIdentifier);
		assertEquals("Food allergy", allergy.getCategory());
	}

	@Test
	public void retrieveAllergiesContainsReaction() {
		Allergy allergy = getTestAllergyFromGetAllAllergies(patientIdentifier);
		assertEquals("Hives", allergy.getReaction());
	}

	@Test
	public void fetchAllergiesNoDataReturned() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "healthy");
		AllergyDataService dataService = new AllergyDataService();
		Allergies allergies = dataService.fetchPatientAllergies(patientIdentifier);
		assertNotNull(allergies);
		assertEquals(0, allergies.size());
	}

	@Test
	public void fetchAllergiesInvalidPatientIdentifier() {
		PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "unknown");
		AllergyDataService dataService = new AllergyDataService();
		Allergies allergies = dataService.fetchPatientAllergies(patientIdentifier);
		assertNotNull(allergies);
		assertEquals(0, allergies.size());
	}

}
