package com.agilex.healthcare.mobilehealthplatform.datalayer.admission;

import static org.junit.Assert.assertEquals;

import com.agilex.healthcare.mobilehealthplatform.test.SpringBasedIntegration;
import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;
import com.agilex.healthcare.mobilehealthplatform.domain.DataIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;

public class AdmissionDataServiceTest extends SpringBasedIntegration{

	private PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "D123401");

	@Test
	public void fetch() {
		AdmissionDataService dataservice = new AdmissionDataService();
		Admissions patientAdmissions = dataservice.getPatientAdmissions(patientIdentifier, DateFilterFactory.createEmptyFilter(), ScopeFilter.getInstanceForLongitudinalScope());
		assertEquals(10, patientAdmissions.size());
	}

	@Ignore
	@Test
	public void fetchSingle() {
		AdmissionDataService dataservice = new AdmissionDataService();
		Admission patientAdmissions = dataservice.getPatientAdmission(patientIdentifier, new DataIdentifier("cdw", "1"));
		assertEquals("cdw", patientAdmissions.getDataIdentifier().getSystemId());
		assertEquals("1", patientAdmissions.getDataIdentifier().getUniqueId());
	}

}
