package com.agilex.healthcare.mobilehealthplatform.datalayer.vitals;

import static org.junit.Assert.*;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalEntryFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.utility.DateHelper;

public class VitalDataLayerMockTest {

	VitalEntryFilter filter = new VitalEntryFilter();

	@Test
	public void getPrestagedVital() {
		VitalDataLayer dao = new VitalDataLayerMock();
		VitalEntries vitals = dao.getVitalEntries("D123401", filter);
		assertTrue("We need more than 16 vitals here", vitals.size() > 16);
	}

	@Test
	public void get0Vitals() {
		VitalDataLayer dao = new VitalDataLayerMock();
		VitalEntries vitals = dao.getVitalEntries("invalid", filter);
		assertEquals(0, vitals.size());
	}

	@Test
	public void addAndRetrieveVitals() {
		VitalDataLayer dao = new VitalDataLayerMock();
		String patientId = "pat1";
		VitalEntries vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(0, vitals.size());

		VitalEntry vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		VitalEntry savedEntry = dao.saveVitalEntry(vitalEntry);

		vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(1, vitals.size());
		assertEquals(savedEntry.getId(), vitals.get(0).getId());
	}

	@Test
	public void retrieveBySection() {
		VitalDataLayer dao = new VitalDataLayerMock();
		String patientId = "pat2";
		VitalEntries vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(0, vitals.size());

		VitalEntry vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		VitalEntry savedEntryA = dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("B");
		dao.saveVitalEntry(vitalEntry);

		VitalEntryFilter filter = new VitalEntryFilter();
		filter.setSection("A");
		vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(1, vitals.size());
		assertEquals(savedEntryA.getId(), vitals.get(0).getId());
	}

	@Test
	public void retrieveBySectionWithDates() {
		String patientId = "pat3";
		Date dtA = DateHelper.parseDate("1/1/2011");
		Date dtB = DateHelper.parseDate("1/10/2011");
		Date dtC = DateHelper.parseDate("1/11/2011");
		Date dtD = DateHelper.parseDate("1/12/2011");
		Date dtE = DateHelper.parseDate("1/20/2011");

		VitalDataLayer dao = new VitalDataLayerMock();
		VitalEntries vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(0, vitals.size());

		VitalEntry vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtA);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtB);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtC);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtD);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtE);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("B");
		vitalEntry.setEntryDate(dtC);
		dao.saveVitalEntry(vitalEntry);

		vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(6, vitals.size());

		VitalEntryFilter filter = new VitalEntryFilter();
		filter.setStartDate(dtB);
		filter.setEndDate(dtD);
		vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(4, vitals.size());

		filter = new VitalEntryFilter();
		filter.setSection("A");
		filter.setStartDate(dtB);
		filter.setEndDate(dtD);
		vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(3, vitals.size());
	}

	@Test
	public void retieveByDay() {
		String patientId = "pat4";
		Date dtA = DateHelper.parseDate("1/1/2011");
		Date dtB = DateHelper.parseDate("1/10/2011");
		Date dtC = DateHelper.parseDate("1/11/2011");
		Date dtD = DateHelper.parseDate("1/12/2011");
		Date dtE = DateHelper.parseDate("1/20/2011");

		VitalDataLayer dao = new VitalDataLayerMock();
		VitalEntries vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(0, vitals.size());

		VitalEntry vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtA);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtB);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtC);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtD);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtE);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("B");
		vitalEntry.setEntryDate(dtC);
		dao.saveVitalEntry(vitalEntry);

		vitalEntry = new VitalEntry();
		vitalEntry.setPatientId(patientId);
		vitalEntry.setSection("A");
		vitalEntry.setEntryDate(dtC);
		dao.saveVitalEntry(vitalEntry);

		VitalEntryFilter filter = new VitalEntryFilter();
		filter.setStartDate(dtC);
		filter.setEndDate(dtC);
		vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(3, vitals.size());

		filter = new VitalEntryFilter();
		filter.setSection("A");
		filter.setStartDate(dtC);
		filter.setEndDate(dtC);
		vitals = dao.getVitalEntries(patientId, filter);
		assertEquals(2, vitals.size());
	}
}
