package com.agilex.healthcare.mobilehealthplatform.datalayer.vitals;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.vital.VitalEntryFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntries;
import com.agilex.healthcare.mobilehealthplatform.domain.VitalEntry;
import com.agilex.healthcare.mobilehealthplatform.domain.code.ObservationTypeCode;
import com.agilex.healthcare.utility.DateHelper;

public class VitalDataLayerExcelTest {
	
	VitalEntryFilter filter = new VitalEntryFilter();
	VitalDataLayer dataLayer = new VitalDataLayerExcel();

	@Test
	public void getPrestagedVitals() {
		VitalEntries vitals = dataLayer.getVitalEntries("D123401", filter);
		for (VitalEntry entry : vitals) {
			System.out.println("id here " + entry.getId());
		}
		assertTrue(vitals.size() > 0);

		assertEquals("A", vitals.get(0).getId());
		assertEquals("130", vitals.get(0).getObservationValueByType(ObservationTypeCode.INTRAVASCULAR_SYSTOLIC));
		assertEquals(DateHelper.parseDateTime("12/01/2011 11:00:00"), vitals.get(0).getEntryDate());

		assertEquals("B", vitals.get(1).getId());
		assertEquals("205", vitals.get(1).getObservationValueByType(ObservationTypeCode.WEIGHT));

		assertEquals("C", vitals.get(2).getId());
		assertEquals("98.6", vitals.get(2).getObservationValueByType(ObservationTypeCode.BODY_TEMPERATURE));
	}

	@Test
	public void get0Vitals() {
		VitalEntries vitals = dataLayer.getVitalEntries("invalid", filter);
		assertEquals(0, vitals.size());
	}
	
	@Test
	public void validateSectionFilters() {
		VitalEntryFilter filter = new VitalEntryFilter("BP", null, null);
		VitalEntries vitalEntries = dataLayer.getVitalEntries("D123401", filter);
		
		for(VitalEntry entry : vitalEntries) {
			assertEquals("BP", entry.getSection());
		}
	}
	
	@Test
	public void validateDateFilters() {
		VitalEntryFilter filter = new VitalEntryFilter(null, DateHelper.parseDate("12/31/2011"), DateHelper.parseDate("12/31/2012"));
		VitalEntries vitalEntries = dataLayer.getVitalEntries("D123401", filter);
		
		assertTrue(String.format("Should be greater than or equal to 6 but was %s ", vitalEntries.size())+ vitalEntries.size(), vitalEntries.size() >= 6);
	}
}
