package com.agilex.healthcare.mobilehealthplatform.datalayer.surgery;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Surgeries;
import com.agilex.healthcare.mobilehealthplatform.domain.Surgery;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.DateHelper;

public class SurgeryDataLayerExcelTest {

	@Test
	public void readSurgeryData() {
		SurgeryDataLayerExcel dao = new SurgeryDataLayerExcel();
		Surgeries surgeries = dao.getPatientSurgeries("D123401", null);
		assertNotNull(surgeries);
		assertTrue(surgeries.size() > 0);
	}

	@Test
	public void checkFirstItemPopulated() {
		SurgeryDataLayerExcel dao = new SurgeryDataLayerExcel();
		Surgeries surgeries = dao.getPatientSurgeries("D123401", null);
		assertEquals("1", surgeries.get(0).getUniqueId());
	}

	@Test
	public void readFilteredSurgeries() {
		SurgeryDataLayerExcel dao = new SurgeryDataLayerExcel();
		DateFilter filter = DateFilterFactory.createFilterFromDate("1/1/2011");
		Surgeries surgeries = dao.getPatientSurgeries("D123401", filter);
		assertNotNull(surgeries);
		assertTrue(surgeries.size() > 0);
	}
	
	@Test
	public void readUniqueId() {
		assertEquals("1", getSurgery("1").getUniqueId());
	}

	@Test
	public void readSurgeryDate() {
		assertEquals(DateHelper.parseDate("1/1/2011"), getSurgery("1").getProcedureDate());
	}
	
	@Test
	public void readSurgeryProcedure() {
		assertEquals("Tonsillectomy", getSurgery("1").getProcedure());
	}
	
	@Test
	public void readSurgeryFacility() {
		assertEquals("VA", getSurgery("1").getFacility());
	}

	private Surgery getSurgery(String uniqueId) {
		SurgeryDataLayerExcel dao = new SurgeryDataLayerExcel();
		DateFilter filter = DateFilterFactory.createEmptyFilter();
		Surgeries surgeries = dao.getPatientSurgeries("D123401", filter);		
		Surgery surgery = null;
		for (Surgery possibleMatch : surgeries) {
			if (possibleMatch.getUniqueId().contentEquals(uniqueId)) {
				surgery = possibleMatch;
			}
		}
		return surgery;
	}

}
