package com.agilex.healthcare.mobilehealthplatform.datalayer.staffdirectory;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.LinkedList;
import java.util.List;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Provider;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResult;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResults;

public class StaffDirectoryDataLayerMockTest {
	private StaffDirectoryDataLayerMock dataLayer;
	
	private void init() {
		dataLayer = new StaffDirectoryDataLayerMock();
	}
	
	@Test
	public void testSearchByFirstAndLastname() {
		init();
		dataLayer.setUsers(getDataSetA());

		StaffDirectorySearchResults results = dataLayer.searchByFirstAndLastname("facility", "jim", "mason");
		assertNotNull("results were null",results);
		
		boolean found = false;
		for (StaffDirectorySearchResult result : results) {
			if(result.getName().equalsIgnoreCase("Jim Mason")) {
				found = true;
			}
		}
		assertTrue("Jim not found", found);
		
		results = dataLayer.searchByFirstAndLastname("invalidfacility", "jim", "mason");
		assertNotNull("results were null",results);
		assertTrue("expected not to find jim mason in different facility",results.size()==0);

		results = dataLayer.searchByFirstAndLastname("facility", "jim", "baxter");
		assertNotNull("results were null",results);
		assertTrue("expected not to find jim baxter",results.size()==0);
	}
	
	@Test
	public void testSearchByFirstOrLastname() {
		init();
		dataLayer.setUsers(getDataSetA());

		StaffDirectorySearchResults results = dataLayer.searchByFirstOrLastname("facility", "jim", "");
		assertNotNull("results were null",results);
		
		boolean found = false;
		for (StaffDirectorySearchResult result : results) {
			if(result.getName().equalsIgnoreCase("Jim Mason")) {
				found = true;
			}
		}
		assertTrue("Jim not found", found);

		results = dataLayer.searchByFirstOrLastname("facility", null, "mason");
		assertNotNull("results were null",results);
		
		found = false;
		for (StaffDirectorySearchResult result : results) {
			if(result.getName().equalsIgnoreCase("Jim Mason")) {
				found = true;
			}
		}
		assertTrue("Jim not found", found);

		results = dataLayer.searchByFirstOrLastname("facility", "mason", "mason");
		assertNotNull("results were null",results);
		assertTrue("expected to find mason mason",results.size()>0);
		
		results = dataLayer.searchByFirstOrLastname("invalidfacility", "mason", "mason");
		assertNotNull("results were null",results);
		assertTrue("expected not to find mason mason in invalid facility",results.size()==0);
		
		results = dataLayer.searchByFirstOrLastname("facility", "john", "baxter");
		assertNotNull("results were null",results);
		assertTrue("expected not to find jim baxter",results.size()==0);

		results = dataLayer.searchByFirstOrLastname("facility", "", null);
		assertNotNull("results were null",results);
		assertTrue("expected not to find jim baxter",results.size()==0);
	}
	
	@Test
	public void testSearchByEmail() {
		init();
		dataLayer.setUsers(getDataSetB());

		StaffDirectorySearchResults results = dataLayer.searchByEmail("facility", "jim@agilex.com");
		assertNotNull("results were null",results);
		assertTrue("expected to find two",results.size()==2);
		
		results = dataLayer.searchByEmail("invalidfacility", "jim@agilex.com");
		assertNotNull("results were null",results);
		assertTrue("expected to find none in invalid facility",results.size()==0);
	}
	
	@Test
	public void testSearchByEmailNullA() {
		init();
		dataLayer.setUsers(getDataSetA());

		StaffDirectorySearchResults results = dataLayer.searchByEmail("facility", "jim@agilex.com");
		assertNotNull("results were null",results);
		assertTrue("expected to find two",results.size()==0);
	}
	
	@Test
	public void testSearchByEmailNullB() {
		init();
		dataLayer.setUsers(getDataSetB());
		
		StaffDirectorySearchResults results = dataLayer.searchByEmail("facility", null);
		assertNotNull("results were null",results);
		assertTrue("expected to find two",results.size()==0);
	}
	
	@Test
	public void testSearchByPhoneNumber() {
		init();
		dataLayer.setUsers(getDataSetB());

		// cell phone
		StaffDirectorySearchResults results = dataLayer.searchByPhoneNumber("facility", "1");
		assertNotNull("results were null",results);
		assertEquals("expected to find two", 2, results.size());

		results = dataLayer.searchByPhoneNumber("invalidfacility", "1");
		assertNotNull("results were null",results);
		assertEquals("expected to find none in invalid facility", 0, results.size());

		// office phone
		results = dataLayer.searchByPhoneNumber("facility", "2");
		assertNotNull("results were null",results);
		assertEquals("expected to find two", 2, results.size());

		results = dataLayer.searchByPhoneNumber("invalidfacility", "2");
		assertNotNull("results were null",results);
		assertEquals("expected to find none in invalid facility", 0, results.size());

		// digital pager
		results = dataLayer.searchByPhoneNumber("facility", "33");
		assertNotNull("results were null",results);
		assertEquals("expected to find one", 1, results.size());

		results = dataLayer.searchByPhoneNumber("invalidfacility", "33");
		assertNotNull("results were null",results);
		assertEquals("expected to find none in invalid facility", 0, results.size());
		
		// voice pager
		results = dataLayer.searchByPhoneNumber("facility", "431");
		assertNotNull("results were null",results);
		assertEquals("expected to find one", 1, results.size());

		results = dataLayer.searchByPhoneNumber("invalidfacility", "431");
		assertNotNull("results were null",results);
		assertEquals("expected to find none in invalid facility", 0, results.size());

	}
	
	private List<Provider> getDataSetA() {
		List<Provider> users = new LinkedList<Provider>();
		users.add(getUser("jim", "MASON", null, "facility", "1111111111", "2111111111", "3111111111", "4111111111"));
		users.add(getUser("jim", "alger", null, "facility", "1211111111", "2211111111", "3211111111", "4211111111"));
		return users;
	}
	
	private List<Provider> getDataSetB() {
		List<Provider> users = new LinkedList<Provider>();
		users.add(getUser("jim", "MASON", "jim@AGILEX.COM", "facility", "1311111111", "2311111111", "3311111111", "4311111111"));
		users.add(getUser("jim", "alger", "jim@AGILEX.com", "facility", "1411111111", "2411111111", "3411111111", "4411111111"));
		return users;
	}
	
	private Provider getUser(String firstName, String lastName, String email, String facility, String cellPhone, String officePhone, String digitalPager, String voicePager) {
		Provider user = new Provider();
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmailAddress(email);
        user.addVistaLocation(facility);
        
        user.setCellPhone(cellPhone);
        user.setOfficePhone(officePhone);
        user.setDigitalPager(digitalPager);
        user.setVoicePager(voicePager);
        return user;
	}
}
