package com.agilex.healthcare.mobilehealthplatform.datalayer.rightofaccess;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.InputStream;
import java.util.Date;
import java.util.UUID;

import org.apache.commons.io.IOUtils;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.RightOfAccessInfo;
import com.agilex.healthcare.utility.DateHelper;

public class RightOfAccessDataLayerMockTest {
	private String userId = UUID.randomUUID().toString();
	private RightOfAccessDataLayer datalayer = new RightOfAccessDataLayerMock();
	private String RESOURCE_DIR = "com/agilex/healthcare/mobilehealthplatform/datalayer/rightofaccess/";

	@Test
	public void testSaveAndGetRightOfAccessInfo() throws Exception{
		RightOfAccessInfo info = generateRightOfAccessInfo(true);
		RightOfAccessInfo savedInfo = datalayer.saveRightOfAccessInfo(info);
		compareRightOfAccessInfo(info, savedInfo);

		RightOfAccessInfo retrievedInfo = datalayer.getRightOfAccessInfo(userId);
		compareRightOfAccessInfo(info, retrievedInfo);
	}

	private RightOfAccessInfo generateRightOfAccessInfo(boolean accepted) throws Exception{
		InputStream roaImageStream = this.getClass().getClassLoader().getResourceAsStream(RESOURCE_DIR + "ROA.pdf");
		byte[] roaImage = IOUtils.toByteArray(roaImageStream);

		RightOfAccessInfo info = new RightOfAccessInfo(userId, accepted, new Date(), roaImage);
		return info;
	}
	
	private void compareRightOfAccessInfo(RightOfAccessInfo expected, RightOfAccessInfo actual) {
		assertEquals(expected.getUserId(), actual.getUserId());
		assertEquals(expected.isRightOfAccessAccepted(), actual.isRightOfAccessAccepted());
		assertNotNull(actual.getRightOfAccessPDF());
		Date expectedDay = expected.getRightOfAccessDate();
		Date actualDay = actual.getRightOfAccessDate();
		assertTrue(DateHelper.calculateDeltaInDays(expectedDay, actualDay) == 0);
	}	
}
