package com.agilex.healthcare.mobilehealthplatform.datalayer.radiology;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.utility.DateHelper;

public class RadiologyDataLayerExcelTest {
	@Test
	public void getRadiologyResults() {
		RadiologyDataLayer dao = new RadiologyDataLayerExcel();
		PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "D123401");
		RadiologyResults results = dao.getResults(patientIdentifier, null);
		assertEquals(22, results.size());
	}

	@Test
	public void verifyShortTestName() {
		assertEquals("Chest (MRI)", getRadiologyResult().getTestShortName());
	}

	@Test
	public void verifyTestName() {
		assertEquals("Chest MRI", getRadiologyResult().getTestName());
	}

	@Test
	public void verifyFacility() {
		assertEquals("WV", getRadiologyResult().getFacilityName());
	}

	@Test
	public void verifyResultDate() {
		assertEquals(DateHelper.parseDate("7/1/2011"), getRadiologyResult().getResultedDate());
	}

	@Test
	public void verifyInterpretation() {
		assertEquals("Normal Chest", getRadiologyResult().getInterpretation());
	}

	@Test
	public void verifyReport() {
		assertEquals("REPORT", getRadiologyResult().getReport());
	}

	private RadiologyResult getRadiologyResult() {
		String patientId = "D123401";
		String id = "5";
		return getRadiologyResult(patientId, id);
	}

	private RadiologyResult getRadiologyResult(String patientId, String id) {
		RadiologyDataLayer dao = new RadiologyDataLayerExcel();
		PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", patientId);
		return dao.fetchResult(patientIdentifier, id);
	}
}
