package com.agilex.healthcare.mobilehealthplatform.datalayer.provider;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilter;
import com.agilex.healthcare.mobilehealthplatform.domain.filter.datefilter.DateFilterFactory;
import com.agilex.healthcare.utility.DateHelper;
import org.junit.Before;
import org.junit.Test;

import java.util.Date;

import static org.junit.Assert.assertEquals;

public class ProviderDataLayerExcelTest {

	private ProviderDataLayer dataLayer;

	@Before
	public void setUp() {
		dataLayer = new ProviderDataLayerExcel();
	}

	@Test
	public void verifyValidPrimaryCareProvidersAreReturned() {
		PatientProviders providers = dataLayer.fetchPrimaryCareProviders(createD123401PatientIdentifier());
        assertEquals(2, providers.size());
	}

	@Test
	public void verifyValidMentalHealthProvidersAreReturned() {
        PatientProviders providers = dataLayer.fetchMentalHealthProviders(createD123401PatientIdentifier(), DateFilterFactory.createEmptyFilter(),null);
		assertEquals(4, providers.size());
	}

	@Test
	public void mentalHealthProvidersFilteredByFacilitySiteCode() {
        PatientProviders providers = dataLayer.fetchMentalHealthProviders(createD123401PatientIdentifier(), DateFilterFactory.createEmptyFilter(),"688");
		assertEquals(3, providers.size());
	}
	@Test
	public void verifyValidMentalHealthProvidersAreReturnedForSpecificDates() {
        //Set date filter based upon current date
        Date today = DateHelper.getToday();
        DateFilter dateFilter = DateFilterFactory.createFilterFromDate(DateHelper.minusMonths(today, 24), today);
		PatientProviders providers = dataLayer.fetchMentalHealthProviders(createD123401PatientIdentifier(), dateFilter, "688");
		assertEquals(0, providers.size());
	}

	@Test
	public void verifyNoPrimaryCareProvidersAreReturnedForInvalidPatient() {
		PatientProviders providers = dataLayer.fetchPrimaryCareProviders(createXyzPatientIdentifier());
		assertEquals(0, providers.size());
	}

	@Test
	public void verifyNoMentalHealthProvidersAreReturnedForInvalidPatient() {
		PatientProviders providers = dataLayer.fetchMentalHealthProviders(createXyzPatientIdentifier(), null, "");
		assertEquals(0, providers.size());
	}

    PatientIdentifier createXyzPatientIdentifier(){
        PatientIdentifier patientIdentifier = new PatientIdentifier();
        patientIdentifier.setAssigningAuthority("");
        patientIdentifier.setUniqueId("xyz");
        return patientIdentifier;
    }

    PatientIdentifier createD123401PatientIdentifier(){
        PatientIdentifier patientIdentifier = new PatientIdentifier();
        patientIdentifier.setAssigningAuthority("mock-aa");
        patientIdentifier.setUniqueId("D123401");
        return patientIdentifier;
    }


}
