package com.agilex.healthcare.mobilehealthplatform.datalayer.problem;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.utility.DateHelper;

public class ProblemDataLayerExcelTest {

	private ProblemDataLayerExcel dataLayer;
	private Problems problems;
	private String PATIENTID = "D123401";
	
	@Before
	public void setup() {
		dataLayer = new ProblemDataLayerExcel();
		problems = dataLayer.fetchProblems(PATIENTID);
	}

	@Test
	public void validateProblemsAreReturnedForYounger() {
		assertTrue(problems.size() > 0);		
	}
	
	@Test
	public void validateProblemID() {		
		String actualID = problems.get(0).getProblemId();
		assertEquals("1",actualID);
	}

	@Test
	public void validateProblemDescription() {
		String actualID = problems.get(0).getDescription();
		assertEquals("ankle joint pain",actualID);		
	}
	
	@Test
	public void validateActive() {
		assertTrue(problems.get(0).isActive());		
	}
	
	@Test
	public void validateOnsetDate() {
		Date actualOnsetDate = problems.get(0).getOnsetDate();
		assertEquals(DateHelper.parseDate("10/29/2010"),actualOnsetDate);		
	}

	@Test
	public void validateComments() {
		String actualComments = problems.get(0).getComments();
		assertEquals("",actualComments);		
	}

	@Test
	public void validateZeroProblemsAreReturnedForXYZ() {
		String patientId = "XYZ";
		Problems problems = dataLayer.fetchProblems(patientId);
		assertEquals(0, problems.size());
	}

	@Test
	public void validateZeroProblemsAreReturnedForNull() {
		String patientId = null;
		Problems problems = dataLayer.fetchProblems(patientId);
		assertEquals(0, problems.size());
	}
}
