package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.excel.PatientExcelParser;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.DateHelper;

@Ignore
public class PatientsExcelParserTest {
	private static final String GALLOW_ID = "D123401";

	@Test
	public void parserReturnsCorrectNumberOfRows() {
		PatientExcelParser parser = new PatientExcelParser();
		Patients patients = parser.getDataCollection("patients.xls");
		assertNotNull(patients);
		assertEquals(3, patients.size());
	}

	@Test
	public void parserFillsId() {
		Patient patient = findPatientById(GALLOW_ID);
		assertNotNull("Unable to find patient", patient);
		assertEquals(GALLOW_ID, patient.getId());
	}

	@Test
	public void parserFillsLastName() {
		Patient patient = findPatientById(GALLOW_ID);
		assertEquals("Younger", patient.getLastName());
	}

	@Test
	public void parserFillsFirstName() {
		Patient patient = findPatientById(GALLOW_ID);
		assertEquals("Gallow", patient.getFirstName());
	}

	@Test
	public void parserFillsFirstMiddleName() {
		Patient patient = findPatientById(GALLOW_ID);
		assertEquals("A", patient.getMiddleName());
	}

	@Test
	public void parserFillsGender() {
		Patient patient = findPatientById(GALLOW_ID);
		assertEquals("M", patient.getGender());
	}

	@Test
	public void parserFillsSsn() {
		Patient patient = findPatientById(GALLOW_ID);
		assertEquals("123456789", patient.getSsn());
	}

	@Test
	public void parserFillsFirstDob() {
		Patient patient = findPatientById(GALLOW_ID);
		assertEquals(DateHelper.parseDate("05/05/1975"), patient.getDateOfBirth().getDate());
	}

	private Patient findPatientById(String id) {
		PatientExcelParser parser = new PatientExcelParser();
		Patients patients = parser.getDataCollection("patients.xls");
		Patient match = null;
		for (Patient potentialMatch : patients) {
			if (potentialMatch.getId().equalsIgnoreCase(id))
				match = potentialMatch;
		}
		return match;
	}
}
