package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import org.junit.Test;

import static org.junit.Assert.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;

public class PatientSupplementalDemographicsDataLayerMockTest {
	PatientSupplementalDemographicsDataLayerMock dataLayer = new PatientSupplementalDemographicsDataLayerMock();
	
	@Test
	public void verifyRetrieve() {
		PatientDemographics demographics = dataLayer.fetchDemographics(new PatientIdentifier("EDIPI", "D123401"));
		
		assertNotNull(demographics);
		assertEquals(3, demographics.getAddresses().size());
		assertEquals(4, demographics.getPhoneNumbers().size());
		assertNotNull(demographics.getNextOfKin());
		assertEquals("Permanent", demographics.getAddress().getAddressType());
		assertEquals("Kin, Next EDIPI#D123401", demographics.getNextOfKin().getName());
		assertEquals("(000)000-0000", demographics.getPhoneNumberHome());
		assertEquals("(111)111-1111", demographics.getPhoneNumberWork());
		assertEquals("(222)222-2222", demographics.getPhoneNumberMobile());
		assertEquals("(333)333-3333", demographics.getPhoneNumberPager());
	}
}
