package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;

public class PatientMetadataDataLayerExcelTest {
	private PatientMetadataDataLayerExcel dataLayer = new PatientMetadataDataLayerExcel();
	private List<PatientMetadata> patientMetadataList;
	static private String TEST_PATIENT = "D123401";
	
	public PatientMetadataDataLayerExcelTest() {
		patientMetadataList = dataLayer.fetchPatientMetadataList();
	}
	
	@Test
	public void validateNumberOfPatientMetadataList() {
		assertEquals(1, patientMetadataList.size());
	}
	
	@Test
	public void validatePatientMetadataList(){
		assertNotNull(patientMetadataList);
		assertTrue(patientMetadataList.size() > 0);
		for (PatientMetadata patientMetadata : patientMetadataList) {
			if (TEST_PATIENT.equals(patientMetadata.getPatientId())) {
				assertNotNull(patientMetadata.getLastAppointmentRequestAccessDate());
			}
		}
	}
}
