package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import javax.ws.rs.WebApplicationException;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class PatientInternalDataLayerExcelTest {
	private static PatientInternalDataLayer dao;
	private static Patient testPatient;
	private static String firstName = "Gallow";
	private static String lastName = "Younger";
	
	private static boolean textMessagingAllowed = true;
	private static String textMessagingPhoneNumber = "324-234-3234";
	
	private static String patientId = "D123401";
	
	static {
		dao = new PatientInternalDataLayerExcel();
		
		testPatient = new Patient();
		testPatient.setId(patientId);
		testPatient.setFirstName(firstName);
		testPatient.setLastName(lastName);
		testPatient.setTextMessagingAllowed(textMessagingAllowed);
		testPatient.setTextMessagingPhoneNumber(textMessagingPhoneNumber);
	}
	
	public PatientInternalDataLayerExcelTest() {
	}
	
	@BeforeClass
	public static void setup() {
		dao.savePatient(testPatient);
	}
	
	@AfterClass
	public static void tearDown() {
		dao.removePatient(testPatient.getId());
	}
	
	@Test
	public void fetchPatients() {
		Patients patients = dao.fetchPatients();
		assertTrue(patients.size() > 0);
	}
	
	@Test
	public void findByInvalidPatientId() {
		String invalidCode = "invalidCode";
		
		boolean hasWebApplicationException = false;
		try {
			 dao.fetchPatientById(invalidCode);
		} catch (WebApplicationException e) {
			hasWebApplicationException = true;
		}
		
		assertTrue(hasWebApplicationException);
	}
	

	@Test
	public void findByValidId() {
		String validId = patientId;
		
		Patient patient = dao.fetchPatientById(validId);
		assertNotNull(patient);
		
		assertEquals(patientId, patient.getId());
		assertEquals(firstName, patient.getFirstName());
		assertEquals(lastName, patient.getLastName());
		assertEquals(textMessagingAllowed, patient.isTextMessagingAllowed());
		assertEquals(textMessagingPhoneNumber, patient.getTextMessagingPhoneNumber());
	}
}
