package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.excel.PatientDemographicsExcelParser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;

public class PatientDemographicsExcelParserTest {
	private static final String GALLOW_ID = "D123401";
	private PatientDemographics patient;

	@Before
	public void setup() {
		PatientDemographicsExcelParser parser = new PatientDemographicsExcelParser();
		patient = parser.getData("patients.xls", GALLOW_ID);
	}

	@Test
	public void foundDemographics() {
		assertNotNull(patient);
	}

	@Test
	public void streetAddress() {
		assertNotNull(patient.getAddress());
	}

	@Test
	public void streetAddress1() {
		assertEquals("345 Tester Lane", patient.getAddress().getStreetAddressLine1());
	}

	@Test
	public void streetAddress2() {
		assertEquals("APT. 123", patient.getAddress().getStreetAddressLine2());
	}

	@Test
	public void streetAddress3() {
		assertEquals("P.O. Box 1234", patient.getAddress().getStreetAddressLine3());
	}

	@Test
	public void city() {
		assertEquals("Chantilly", patient.getAddress().getCity());
	}

	@Test
	public void state() {
		assertEquals("VA", patient.getAddress().getState());
	}

	@Test
	public void zip() {
		assertEquals("20151", patient.getAddress().getZipCode());
	}

	@Test
	public void pager() {
		assertEquals("888-888-8888", patient.getPhoneNumberPager());
	}

	@Test
	public void mobile() {
		assertEquals("666-666-6666", patient.getPhoneNumberMobile());
	}

	@Test
	public void home() {
		assertEquals("222-222-2222", patient.getPhoneNumberHome());
	}

	@Test
	public void work() {
		assertEquals("555-555-5555", patient.getPhoneNumberWork());
	}

	@Test
	public void nok() {
		assertNotNull(patient.getNextOfKin());
	}

	@Test
	public void nokName() {
		assertEquals("Younger, Mother", patient.getNextOfKin().getName());
	}

	@Test
	public void nokRelationship() {
		assertEquals("MOTHER", patient.getNextOfKin().getRelationship());
	}

	@Test
	public void nokNumber() {
		assertEquals("555-555-5555", patient.getNextOfKin().getPhoneNumber());
	}

}
