package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.excel.PatientDataLayerExcel;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class PatientDataLayerExcelPatientSearch {
	@Test
	public void searchByLastName() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(new Patient());
		criteria.getPrototype().setLastName("younger");

		PatientDataLayer datalayer = new PatientDataLayerExcel();
		Patients patients = datalayer.patientSearch(criteria);

		assertNotNull(patients);
		assertEquals(1, patients.size());
		assertEquals("Younger", patients.get(0).getLastName());
	}

	@Test
	public void searchNoResult() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(new Patient());
		criteria.getPrototype().setLastName("invalid");

		PatientDataLayer datalayer = new PatientDataLayerExcel();
		Patients patients = datalayer.patientSearch(criteria);

		assertNotNull(patients);
		assertEquals(0, patients.size());
	}

	@Test
	public void searchBy     () {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(new Patient());
		criteria.getPrototype().setLastName("smith");

		PatientDataLayer datalayer = new PatientDataLayerExcel();
		Patients patients = datalayer.patientSearch(criteria);

		assertNotNull(patients);
		assertEquals(2, patients.size());
	}
}
