package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.enumeration.MygoalsInventoryType;


public class MygoalsDataLayerMockTest {
	
	MygoalsDataLayerMock datalayer = new MygoalsDataLayerMock();

	@Test
	public void verifyMygoalsExistForGallow() {
		MygoalsList mygoalsList = datalayer.fetchMygoalsListByPatient("D123401");
		assertNotNull(mygoalsList);
		assertTrue(mygoalsList.size() > 0);
	}

	@Test
	public void verifyMygoalsExistForAldie() {
		MygoalsList mygoalsList = datalayer.fetchMygoalsListByPatient("PATID26");
		assertNotNull(mygoalsList);
		assertTrue(mygoalsList.size() > 0);
	}

	@Test
	public void verifyMygoalsExistForOtherData() {
		MygoalsList mygoalsList = datalayer.fetchMygoalsListByPatient("testPatientId");
		assertNotNull(mygoalsList);
		assertTrue(mygoalsList.size() > 0);
	}

	@Test
	public void verifyLatestMygoalsExistForGallow() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsList("D123401");
		assertNotNull(mygoalsList);
		assertTrue(mygoalsList.size() > 0);
	}

	@Test
	public void verifyLatestMygoalsExistForAldie() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsList("PATID26");
		assertNotNull(mygoalsList);
		assertTrue(mygoalsList.size() > 0);
	}

	@Test
	public void verifyLatestMygoalsExistForOtherData() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsList("testPatientId");
		assertNotNull(mygoalsList);
		assertTrue(mygoalsList.size() > 0);
	}
	
	@Test
	public void verifyMygoalsByInventoryTypeForGallow() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.FEELINGS.name());
		assertNotNull(mygoalsList);
		
		assertInventoryType(mygoalsList, MygoalsInventoryType.FEELINGS.name());

		mygoalsList = datalayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());

		mygoalsList = datalayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.REFLECTIONS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.REFLECTIONS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.PRIORITIES.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.PRIORITIES.name());


	}

	private void assertInventoryType(MygoalsList mygoalsList, String expectedInvType) {
		for (Mygoals mygoals : mygoalsList) {
			assertEquals(expectedInvType, mygoals.getInventoryType());
		}		
	}

	@Test
	public void verifyMygoalsByInventoryTypeForAldie() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.FEELINGS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.FEELINGS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());

		mygoalsList = datalayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.REFLECTIONS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.REFLECTIONS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.PRIORITIES.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.PRIORITIES.name());
		
	}

	@Test
	public void verifyMygoalsByInventoryTypeForOtherData() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsListByType("testPatientId", MygoalsInventoryType.FEELINGS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.FEELINGS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("testPatientId", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());

		mygoalsList = datalayer.fetchLatestMygoalsListByType("testPatientId", MygoalsInventoryType.REFLECTIONS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.REFLECTIONS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("testPatientId", MygoalsInventoryType.PRIORITIES.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.PRIORITIES.name());
		
	}
	
	@Test
	public void verifyLatestMygoalsForGallow() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.FEELINGS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.FEELINGS.name());

		mygoalsList = datalayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());

		mygoalsList = datalayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.REFLECTIONS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.REFLECTIONS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.PRIORITIES.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.PRIORITIES.name());

	}

	@Test
	public void verifyLatestMygoalsForAldie() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.FEELINGS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.FEELINGS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());

		mygoalsList = datalayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.REFLECTIONS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.REFLECTIONS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.PRIORITIES.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.PRIORITIES.name());
		
	}

	@Test
	public void verifyLatestMygoalsForOtherData() {
		MygoalsList mygoalsList = datalayer.fetchLatestMygoalsListByType("testPatientId", MygoalsInventoryType.FEELINGS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.FEELINGS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("testPatientId", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());

		mygoalsList = datalayer.fetchLatestMygoalsListByType("testPatientId", MygoalsInventoryType.REFLECTIONS.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.REFLECTIONS.name());
		
		mygoalsList = datalayer.fetchLatestMygoalsListByType("testPatientId", MygoalsInventoryType.PRIORITIES.name());
		assertNotNull(mygoalsList);
		assertInventoryType(mygoalsList, MygoalsInventoryType.PRIORITIES.name());
		
	}
	
}