package com.agilex.healthcare.mobilehealthplatform.datalayer.mygoals;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.enumeration.MygoalsInventoryType;

public class MygoalsDataLayerExcelTest {

	
	@Test
	public void validateLatestInventoryResponses() {
		MygoalsDataLayerExcel dataLayer = new MygoalsDataLayerExcel();
		MygoalsList latestmygoalsList = dataLayer.fetchLatestMygoalsList("D123401");
		assertTrue(latestmygoalsList.size() > 0);

		MygoalsList mygoalsList = dataLayer.fetchMygoalsListByPatient("D123401");
		assertTrue(mygoalsList.size() > 0);
		assertTrue (latestmygoalsList.size() < mygoalsList.size() || latestmygoalsList.size() == mygoalsList.size()); 

		latestmygoalsList = dataLayer.fetchLatestMygoalsList("PATID26");
		assertTrue(latestmygoalsList.size() > 0);

	    mygoalsList = dataLayer.fetchMygoalsListByPatient("PATID26");
		assertTrue(mygoalsList.size() > 0);
		assertTrue (latestmygoalsList.size() < mygoalsList.size() || latestmygoalsList.size() == mygoalsList.size()); 
		
	}

	@Test
	public void validateLatestMygoalsListByType() {
		MygoalsDataLayerExcel dataLayer = new MygoalsDataLayerExcel();
		MygoalsList latestMygoalsList = dataLayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.FEELINGS.name());
		assertTrue(latestMygoalsList.size() > 0);

		for (Mygoals mygoals : latestMygoalsList) {
			assertEquals(MygoalsInventoryType.FEELINGS.name(), mygoals.getInventoryType());
		}

		latestMygoalsList = dataLayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		assertTrue(latestMygoalsList.size() > 0);

		for (Mygoals mygoals : latestMygoalsList) {
			assertEquals(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), mygoals.getInventoryType());
		}

		latestMygoalsList = dataLayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.REFLECTIONS.name());
		assertTrue(latestMygoalsList.size() > 0);

		for (Mygoals mygoals : latestMygoalsList) {
			assertEquals(MygoalsInventoryType.REFLECTIONS.name(), mygoals.getInventoryType());
		}
		
		latestMygoalsList = dataLayer.fetchLatestMygoalsListByType("D123401", MygoalsInventoryType.PRIORITIES.name());
		assertTrue(latestMygoalsList.size() > 0);

		for (Mygoals mygoals : latestMygoalsList) {
			assertEquals(MygoalsInventoryType.PRIORITIES.name(), mygoals.getInventoryType());
		}

		latestMygoalsList = dataLayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.FEELINGS.name());
		assertTrue(latestMygoalsList.size() > 0);

		for (Mygoals mygoals : latestMygoalsList) {
			assertEquals(MygoalsInventoryType.FEELINGS.name(), mygoals.getInventoryType());
		}

		latestMygoalsList = dataLayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		assertTrue(latestMygoalsList.size() > 0);

		for (Mygoals mygoals : latestMygoalsList) {
			assertEquals(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name(), mygoals.getInventoryType());
		}

		latestMygoalsList = dataLayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.REFLECTIONS.name());
		assertTrue(latestMygoalsList.size() > 0);

		for (Mygoals mygoals : latestMygoalsList) {
			assertEquals(MygoalsInventoryType.REFLECTIONS.name(), mygoals.getInventoryType());
		}
		
		latestMygoalsList = dataLayer.fetchLatestMygoalsListByType("PATID26", MygoalsInventoryType.PRIORITIES.name());
		assertTrue(latestMygoalsList.size() > 0);

		for (Mygoals mygoals : latestMygoalsList) {
			assertEquals(MygoalsInventoryType.PRIORITIES.name(), mygoals.getInventoryType());
		}
	
	}
	
	@Test
	public void validateSaveMygoals() {
		MygoalsDataLayerExcel dataLayer = new MygoalsDataLayerExcel();
		Mygoals mygoals = new Mygoals();
		mygoals.setQuestionKey("Q3");
		mygoals.setAnswer("10");
		mygoals.setDateUpdated(new Date());
		mygoals.setPatientIdentifier(new PatientIdentifier("mock-aa", "D123401"));
		mygoals.setInventoryType(MygoalsInventoryType.FEELINGS.name());
	
		Mygoals resultMygoals = dataLayer.saveMygoals(mygoals);
		assertNotNull(resultMygoals);
		assertNotNull(resultMygoals.getId());

		dataLayer = new MygoalsDataLayerExcel();
		mygoals = new Mygoals();
		mygoals.setQuestionKey("Q3");
		mygoals.setAnswer("10");
		mygoals.setDateUpdated(new Date());
		mygoals.setPatientIdentifier(new PatientIdentifier("mock-aa", "PATID26"));
		mygoals.setInventoryType(MygoalsInventoryType.FEELINGS.name());
	
		resultMygoals = dataLayer.saveMygoals(mygoals);
		assertNotNull(resultMygoals);
		assertNotNull(resultMygoals.getId());
		
	}

	@Test
	public void validateRetrieveMygoalsById() {
		MygoalsDataLayerExcel dataLayer = new MygoalsDataLayerExcel();
		Mygoals mygoals = new Mygoals();
		mygoals.setQuestionKey("Q3");
		mygoals.setAnswer("10");
		mygoals.setDateUpdated(new Date());
		mygoals.setPatientId("D123401");
		mygoals.setPatientIdentifier(new PatientIdentifier("mock-aa", "D123401"));
		mygoals.setInventoryType(MygoalsInventoryType.FEELINGS.name());
	
		Mygoals resultMygoals = dataLayer.saveMygoals(mygoals);
		assertNotNull(resultMygoals);
		assertNotNull(resultMygoals.getId());
	
		Mygoals retrieveMygoals = dataLayer.fetchMygoalsById("D123401", resultMygoals.getId());
		assertNotNull(retrieveMygoals);
		assertNotNull(retrieveMygoals.getId());
		assertEquals(resultMygoals.getId(), retrieveMygoals.getId());

		mygoals = new Mygoals();
		mygoals.setQuestionKey("Q3");
		mygoals.setAnswer("10");
		mygoals.setDateUpdated(new Date());
		mygoals.setPatientId("PATID26");
		mygoals.setPatientIdentifier(new PatientIdentifier("mock-aa", "PATID26"));
		mygoals.setInventoryType(MygoalsInventoryType.FEELINGS.name());
	
		resultMygoals = dataLayer.saveMygoals(mygoals);
		assertNotNull(resultMygoals);
		assertNotNull(resultMygoals.getId());
	
		retrieveMygoals = dataLayer.fetchMygoalsById("PATID26", resultMygoals.getId());
		assertNotNull(retrieveMygoals);
		assertNotNull(retrieveMygoals.getId());
		assertEquals(resultMygoals.getId(), retrieveMygoals.getId());
		
	}

}
