package com.agilex.healthcare.mobilehealthplatform.datalayer.medication.rxrefill;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.code.MedicationRefillCode;

public class MedicationRefillDataLayerMockTest {

	private MedicationRefillDataLayerMock dataLayer;
	private String patientId;
	Medication medication;
	
	@Before
	public void setup() {
		dataLayer = new MedicationRefillDataLayerMock();
		patientId = "D123401";
		medication = new Medication();
	}

	@Test
	public void validateFetchMedications() {
		Medications activeMedications = dataLayer.fetchMedications(patientId);
		assertTrue(activeMedications.size() > 0);
		for(Medication currMedication : activeMedications) {
			assertNotNull(currMedication.getRefillAction());
		}
	}
	
	@Test
	public void validateDetermineRefillActionWhenEligible() {
		setupMedication("90", 15);
		dataLayer.determineRefillAction(medication);
		assertEquals(MedicationRefillCode.REFILL_ACTION_ELIGIBLE, medication.getRefillAction());
	}
	
	@Test
	public void validateDetermineRefillActionWhenNotEligible() {
		setupMedication("30", 9);
		dataLayer.determineRefillAction(medication);
		assertEquals(MedicationRefillCode.REFILL_ACTION_NONE, medication.getRefillAction());
	}
	
	
	private void setupMedication(String daysSupply, int daysToExpiredDate) {
		medication.setRefills("3");
		medication.setTotalRefills(3);
		medication.setDaysSupply(daysSupply);
		medication.setLastFilledDate(new DateTime().minusDays(daysToExpiredDate).toDate());
	}
	
 }
