package com.agilex.healthcare.mobilehealthplatform.datalayer.learn;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.LearnArticle;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategories;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCategory;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnCondition;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnConditions;
import com.agilex.healthcare.mobilehealthplatform.domain.LearnSubCategory;

public class LearnDataLayerMockTest {
	private LearnDataLayerMock datalayerMock = new LearnDataLayerMock();

	@Test
	public void fetchLearnConditions() {
		LearnConditions conditions = datalayerMock.fetchLearnConditions();
		LearnCondition retrievedCondition = conditions.getConditionById("condition1");

		assertTrue(conditions.size() >= 2);
		assertNotNull(retrievedCondition);
		assertEquals("condition1", retrievedCondition.getId());
		assertEquals("First Condition", retrievedCondition.getTitle());
	}

	@Test
	public void fetchLearnCategoriesByCondition() {
		LearnCondition validCondition = new LearnCondition();
		validCondition.setId("condition1");
		LearnCategories categories = datalayerMock.fetchLearnCategories(validCondition);
		LearnCategory retrievedCategory = categories.getCategoryById("categoryA");
		
		assertEquals(3, categories.size());
		assertEquals("Learn about Category A", retrievedCategory.getTitle());
	}

	@Test
	public void fetchLearnCategoriesByInvalidCondition() {
		LearnCondition invalidCondition = new LearnCondition();
		invalidCondition.setId("invalid");
		LearnCategories categories = datalayerMock.fetchLearnCategories(invalidCondition);
		
		assertNotNull(categories);
	}
	
	@Test
	public void fetchLearnCategoryById() {
		LearnCategory category = datalayerMock.fetchLearnCategory("categoryA");
		LearnSubCategory subcategory = category.getSubCategories().getSubCategoryById("subcat1");
		LearnArticle article = subcategory.getArticles().getArticleById("articleA");
		
		assertEquals("Learn about Category A", category.getTitle());
		assertEquals("SubCategory 1", subcategory.getTitle());
		assertEquals("What is Article A about?", article.getTitle());
	}

	@Test
	public void fetchLearnArticleById() {
		LearnArticle article = datalayerMock.fetchLearnArticle("articleA");
		
		assertNotNull(article);
		assertEquals("What is Article A about?", article.getTitle());
		assertEquals("Article A provides information about the letter A.", article.getContent());
	}
}
